/*
 * SetFire.c   C. Scheppner  CBM  01/89
 * Sets right mouseport FIRE pin (pin 6) to 0 or 1
 */

#include <exec/types.h>
#include <hardware/cia.h>
#include <libraries/dos.h>

#define DELAY 500

extern struct CIA ciaa;

main(argc,argv)
int argc;
char **argv;
   {
   ULONG delay = 500;

   if(argc > 1)
      {
      if(argv[1][0]=='?')
         cleanexit("USAGE: SetFire (demos setting joy pin 6 to 1 or 0)\n",0);
      }

   printf("SetFire sets right mouseport pin 6 to ~0v and ~5v\n");
   printf("To exit, use CTRL/C\n");

   /* set right fire pin to output */
   ciaa.ciaddra = ciaa.ciaddra | CIAF_GAMEPORT1;

   /* loop until CTRL/C */
   while(!(SetSignal(0,0) & SIGBREAKF_CTRL_C))
      {
      /* turn off fire pin */
      ciaa.ciapra = ciaa.ciapra & (~CIAF_GAMEPORT1);
      printf("\nSet to 0...");
      Delay(delay);


      /* turn on fire pin */
      ciaa.ciapra = ciaa.ciapra | CIAF_GAMEPORT1;
      printf("  Set to 1...");
      Delay(delay);
      }

   printf("\n");
   /* set right fire pin back to input */
   ciaa.ciaddra = ciaa.ciaddra & (~CIAF_GAMEPORT1);
   exit(0);
   }

cleanexit(s,n)
char *s;
int n;
   {
   if(*s)  printf(s);
   exit(n);
   }

