/*

    Quick program to show how to detect what processor the Amiga is
    running.  This program is not as powerful as the SetCpu program.

 */
#include "exec/types.h"
#include "exec/execbase.h"

#define AFB_68030 2	    /* New flag for 68030 processor. THIS FLAG	*/
#define AFF_68030 (1<<2)   /* is not set by V1.2 or V1.3 Kickstart,    */
			  /* but will be supported in Kickstart V1.4! */

/* declare SysBase to point to struct ExecBase */
extern struct ExecBase *SysBase;


void main()
{
UWORD	flags;

    flags=SysBase->AttnFlags;	/* get flags */

    printf("SysBase->AttnFlags=$%x\n",flags);

    /* The 68010 flag remains set for the 68020, the 68020 flag
       remains set for the 68030, etc. */
    if(flags & AFF_68030)
	printf("68030 Central Processing Unit (CPU) installed\n");
    else if(flags & AFF_68020)
	printf("68020 [or 68030] Central Processing Unit (CPU) installed\n");
    else if(flags & AFF_68010)
	printf("68010 Central Processing Unit (CPU) installed\n");
    else
	printf("68000 Central Processing Unit (CPU) installed\n");

    if(flags & AFF_68881)
	printf("68881 Floating Point Math Coprocessor installed\n");
}

