#include <exec/types.h>
#include <exec/tasks.h>

extern	void trapintercept();

#define NUM_OF_TRAPS 64

void (*localf[NUM_OF_TRAPS])() = {0};

struct Task *FindTask();

char intercepting=0;
APTR oldtraphandler = 0;
APTR oldtrapdata = 0;

void InterceptTrap(n,f)
int n;
void (*f)();
{
	if (intercepting == 0)
	{
		struct Task *t;
		t = FindTask(0);
		oldtraphandler = t->tc_TrapCode;
		oldtrapdata = t->tc_TrapData;
		t->tc_TrapCode = (APTR)(trapintercept);
		/* we don't care about trap data */
	}
	localf[n] = f;
	intercepting++;
}

void UnwindTrap(n)
int n;
{
	if (intercepting)
	{
		intercepting--;
		if (intercepting == 0)
		{	/* now remove interceptor */
			struct Task *t = FindTask(0);
			/* restore original trap handler */
			t->tc_TrapData = oldtrapdata;
			t->tc_TrapCode = oldtraphandler;
		}
		localf[n] = 0;
	}
	else
	{
		printf("bad Unwind call\n");
		exit(-1);
	}
}

/* supervisor code */
void localtrapintercept()
{
}

