
#include <exec/types.h>
#include "setjmp.h"

#define	SIGDIV0	5
#define SIGTRAPV        7
#define SIGFPCP_DIVIDEBY0       50
#define SIGFPCP_OVERFLOW        53

jmp_buf div0_buf;

/*#define LATTICE*/
#ifdef LATTICE
extern	long	MathIeeeDoubBasBase;
#else
long	MathIeeeDoubBasBase = 0;
#endif

/*#define LONGJMPIT*/

void SigTrap0()
{
	printf("divide by zero caught\n");
	longjmp(div0_buf, 1);
}

DOUBLE	zero = 0.0;
DOUBLE	one = 1.0;
DOUBLE	result;

void main(argc,argv)
{
	printf(" Test Divide by zero handling\n");

	MathIeeeDoubBasBase = OpenLibrary("mathieeedoubbas.library",0);

	if (!MathIeeeDoubBasBase)
	{
		printf(" could not open Mathieeedoubbas.library\n");
		exit(-1);
	}

	/* first set up Intercept routine */

#ifdef	LONGJMPIT
	InterceptTrap(SIGDIV0, SigTrap0);	/* for 68000/68010 */
	InterceptTrap(SIGFPCP_DIVIDEBY0, SigTrap0);	/* 68020 */
#else /* ignore it */
	InterceptTrap(SIGDIV0, -1);	/* for 68000/68010 */
	InterceptTrap(SIGFPCP_DIVIDEBY0, -1);	/* 68020 */
#endif

	if (setjmp(div0_buf)) goto caught_div0;

	result = one/zero;

	printf("H'mmm, no error? , oh well result=%lx,%lx\n",result);
		goto exit;

caught_div0:
	printf(" back in main program, and NO guru \n");

exit:
	CloseLibrary(MathIeeeDoubBasBase);
#ifdef LATTICE
	MathIeeeDoubBasBase = 0;
#endif
	exit(0);
}
