/*---------------------------- Start C Source ----------------------------*/

/******************************/
/*          Savage.c          */
/*       Amiga Version        */
/******************************/

/*********************************************************************/
/* Savage Tests the speed at which a system can do a SUBSET of the   */
/* double precision trigonometric and transcendental functions.      */
/*********************************************************************/

#include <stdio.h>
#include <math.h>
double atan(),acos(),asin(),tan(),cos(),sin();
double log(),exp(),sqrt();

/*#define fudge 10*/		/* use this for slow machines */
#define fudge 1			/* used for fast machines */

main()
{
   double a,e;
   int i,iu,loops;

   long  starttime,benchtime,nulltime;  /* Timing Variables and function. */
   long  stoptime, timeticks();         /* timeticks() specific to Amiga. */
                                        /* Replace with your system       */
                                        /* function.                      */

   loops = 25000 / fudge;                        /* Number of loops. Slow  */
                                                /* machines use 2500.     */
                                                /* Faster machines 25,000.*/
                                                /* All results referenced */
                                                /* to 25,000 loop.        */

   printf("\n   Savage Benchmark\n");

   starttime = timeticks();                     /* Determine timer delay  */
   stoptime  = timeticks();
   nulltime  = stoptime  - starttime;

   starttime = timeticks();                        /* Start timer. */

   iu= loops - 1;
   a = 1.0;

      for ( i = 1 ; i<= iu ; i++)
      {
      a = tan(atan(exp(log(sqrt(a*a))))) + 1.0;
      }

   stoptime  = timeticks();                        /* Stop timing . */
   benchtime = stoptime - starttime - nulltime;

   e = a - (double)loops;
   printf("   Benchtime (50 * sec ) = %ld\n",benchtime);
   printf("   loops = %d\n",loops);
   printf("   a     = %24.16e\n",a);
   printf("   Error = %24.16e\n\n",e);

}


/*******************************************************/
/* Timer returns time ticks (50 * sec) since midnight. */
/* Amiga specific, Replace with your own routine.      */
/*******************************************************/

long  timeticks()
{
   struct   tt {
      long  days;
      long  minutes;
      long  ticks;
   } tt;
   DateStamp(&tt);

   return (tt.ticks + (tt.minutes * 60L * 50L));
}

/*-------------------------- End of C Source -----------------------------*/



