/*----------------------- Float C Source Starts Here ---------------------*/


/*******************************************************/
/*                        Float.c                      */
/* Tests speed at which a system does double precision */
/* floating-point multiply and divide instructions. A  */
/* total of 140,000 Double Precision FP operations.    */
/*                                                     */
/*                         Flt.c                       */
/* Tests speed at which a system does double precision */
/* floating-point add, subtract, multiply, and divide  */
/* instructions.  Roughly 1 million DP FP operations.  */
/*******************************************************/

#include <math.h>
#include <stdio.h>


/*******************/
/*     Float.c     */
/*******************/
#define CONST1 3.1415970E0
#define CONST2 1.7839032E4
#define COUNT  10000

main()
{
   double a,b,c;
   long i,j,loops;
   long  starttime,stoptime,benchtime;
   long  nulltime,timeticks();            /* timeticks() is specific to */
                                          /* the Amiga. Replace with    */
                                          /* with your system timer     */
   starttime = timeticks();
   stoptime  = timeticks();
   nulltime  = stoptime - starttime;

   printf("\n   Float Benchmark\n");
   printf("   Start %d Loops \n",COUNT);

   starttime = timeticks();               /* Start timer. */

   a = CONST1;
   b = CONST2;

   for(i=0;i<COUNT;++i)
      {
      c = a*b;
      c = c/a;

      c = a*b;
      c = c/a;

      c = a*b;
      c = c/a;

      c = a*b;
      c = c/a;

      c = a*b;
      c = c/a;

      c = a*b;
      c = c/a;

      c = a*b;
      c = c/a;
      }

   stoptime  = timeticks();               /* Stop timing. */

   benchtime = stoptime - starttime - nulltime;
   a = (double)benchtime/50.0;

   printf("   Done.\n");
   printf("   Benchtime (sec) = %lf\n\n",a);

/***************/
/*    Flt.c    */
/***************/

   loops = 256000;
   printf("   FLT Benchmark\n");
   printf("   Start %ld loops.\n",loops);

   starttime = timeticks();               /* Start timing */

   for( i=1 ; i<=loops ; i++ )
   {
   j = loops - i;
   a = (double)i;
   b = (double)j;
   c = b / a;
   a = b - c;
   b = c * a;
   c = b + a;
   }

   a = c + b;

   stoptime  = timeticks();               /* Stop timing. */

   benchtime = stoptime - starttime - nulltime;
   a = (double)benchtime/50.0;

   printf("   Done.\n");
   printf("   Benchtime (sec) = %lf\n\n",a);

}


/*******************************************************/
/* Function Returns ticks ( 50 per sec) since midnight.*/
/* Amiga specific, Replace with your own routine.      */
/*******************************************************/

long  timeticks()
{
   struct   ds {
      long  days;
      long  minutes;
      long  ticks;
   }  ds;
   DateStamp(&ds);
   return(ds.ticks + (ds.minutes * 60 * 50));
}

/*----------------------- End of C Program Code --------------------------*/



