/*------------------- Start calcpi.c source code -----------------------*/

/*****************************/
/*         CalcPI.c          */
/*      Amiga Version        */
/*    Manx Aztec C V3.4B     */
/*       20 Nov 1987         */
/*****************************/

#include <stdio.h>
#include <math.h>
/*double atan(),acos(),asin(),tan(),cos(),sin();
double log(),exp(),sqrt();*/


long     starttime,stoptime,nulltime;
long     looptime,benchtime,timeticks();  /* timeticks() is specific to  */
double   counts_per_sec;                  /* my system. Please replace   */
                                          /* with your own system timer. */
                                          /* Also change 'counts_per_sec'*/
                                          /* to correspond to your timer.*/


main()
{
   double atanone,one,two,four,SumCheck,SumLog2;
   double sk,xi,xmax;
   double pi_prog,pi_atan,pi_ref,pi_err;
   double sl2_prog,sl2_ref,sl2_err;
   double tloop,tbench,usec,tflops;
   long   i,imax,jmax;

   counts_per_sec = 50.0;                 /* Change this to your timer */
                                          /* counts (ticks) per second.*/

   imax = 125000;
   xmax = (double)imax;
   four = 4.0;
   pi_ref = 3.1415926535897932;

   printf("\n");
   printf("   CalcPI (Double Precision) --------- Version: 20 Nov 1987.\n");
   printf("   A Floating-Point Add, Subtract, Multiply and Divide Test.\n");
   printf("   A total of one million floating-point operations (FLOPS).\n\n");

   starttime = timeticks();
   stoptime  = timeticks();
   nulltime  = stoptime - starttime;

   sk  = -1.0;
   SumCheck = 0.0;

/******************/
/*   First Loop   */
/******************/
   starttime = timeticks();               /* Calculates 'sk', 'SumCheck',*/
                                          /* and 'looptime'.             */
      for ( i = 1 ; i<= imax ; i++ )      /* Correct sign and values of  */
      {                                   /* 'sk' and 'SumCheck' required*/
      sk = -sk;                           /* for Second Loop.            */
      xi = (double)i;
      SumCheck = SumCheck - sk * xi;
      }

   stoptime  = timeticks();
   looptime  = stoptime - starttime - nulltime;

   atanone = 0.0;
   SumLog2 = 0.0;
   one = 1.0;
   two = 2.0;
   jmax = (long)(two * SumCheck);         /* jmax should be 125000 here, */
                                          /* same as imax (!). jmax is   */
                                          /* is printed out at the end   */
                                          /* of the program.             */

/*****************/
/*  Second Loop  */
/*****************/
   starttime = timeticks();               /* Estimates PI,and log(4.0).  */
                                          /* benchtime - looptime is the */
      for ( i = 1 ; i<= jmax ; i++)       /* time (sec) to do 1 million  */
      {                                   /* (+,-,*,/) DP FP operations. */
      sk = -sk;                           /* SumCheck must = xmax (to    */
      xi= (double)i;                      /* machine precision) at the   */
      SumCheck = SumCheck - sk * xi;      /* end of this loop.           */

      atanone  = atanone + sk/(two * xi - one);
      SumLog2  = SumLog2 - sk/(xi * (xi + one));
      }

   stoptime  = timeticks();
   benchtime = stoptime - starttime - nulltime;

/************************************************/
/* Calculate and print out performance results. */
/************************************************/
   pi_prog = four * atanone + one / xmax;
   pi_atan = four * atan(one);
   pi_err  = pi_prog - pi_ref;

   sl2_prog= one - SumLog2 + one/(two * xmax * xmax);
   sl2_ref = log(four);
   sl2_err = sl2_prog - sl2_ref;

   tloop  = (double)looptime  / counts_per_sec;
   tbench = (double)benchtime / counts_per_sec;
   usec   = tbench - tloop;
   tflops = 1000.0 / usec;

   SumCheck = SumCheck - xmax;

   printf("   Iterations (125,000) = %9ld\n",jmax);
   printf("   Looptime (sec)       = %9.4lf\n",tloop);
   printf("   Benchtime(sec)       = %9.4lf\n\n",tbench);

   printf("   log(4): error        =%11.4le\n",sl2_err);
   printf("   SumCheck             =%11.4le\n\n",SumCheck);

   printf("   PI: 4 * atan(1)      = %18.16lf\n",pi_atan);
   printf("   PI: Program          = %18.16lf\n",pi_prog);
   printf("   PI: Reference        = %18.16lf\n",pi_ref);
   printf("   PI: Error            =%11.4le\n\n",pi_err);

   printf("   This Program Conducted: %-9.2lf Kflops/sec\n",tflops);

   printf("   Average Time per flop:  %-9.2lf Microseconds\n\n",usec);

}

/**********************************************************/
/* Function returns time ticks (50 * sec) since midnight. */
/* Amiga specific. Replace with your own system routine.  */
/**********************************************************/
long  timeticks()
{
   struct   tt {
      long  days;
      long  minutes;
      long  ticks;
   } tt;
   DateStamp(&tt);

   return (tt.ticks + (tt.minutes * 60L * 50L));
}

/*---------------------- End calcpi.c source code ----------------------*/




