/*
   Example of opening a simple window on a custom screen - #2
   written by Dan Schein April-88 for the 1988 AMIGA Developers Conference. 

   This example, and all those based on this example, were compiled and
   tested with the Lattice V4.0 compiler.
*/

/*
  Copyright (c) 1988 Commodore-Amiga, Inc.
 
  Executables based on this information may be used in software
  for Commodore Amiga computers.  All other rights reserved.
 
  This information is provided "as is"; no warranties are made.
  All use is at your own risk, and no liability or responsibility is assumed.
*/


#include <exec/types.h>
#include <intuition/intuition.h>
#include <libraries/dos.h>

/*
   Define the Version of the Amiga OS we want (require)

   Operating System Version Information

      0     Any version is OK
      30    1.0 or higher
      31    1.1 NTSC or Higher
      32    1.1 PAL  or Higher
      33    1.2 or higher
      34    1.3 or higher

*/

#define INTUITION_REV 0
#define GRAPHICS_REV  0

struct TextAttr MyFont =
{
   "topaz.font",                             /* Font Name                 */
   TOPAZ_EIGHTY,                             /* Font Height               */
   FS_NORMAL,                                /* Style                     */
   FPF_ROMFONT                               /* Preferences               */
};

struct NewScreen OurScreen =
{
   0, 0,                                     /* LeftEdge and TopEdge     */
   640, 200,                                 /* Width and Height         */
   2,                                        /* Depth (4 colors)         */
   0, 1,                                     /* DetailPen and BlockPen   */
   HIRES,                                    /* Special Display Mode     */
   CUSTOMSCREEN,                             /* The Screen Type          */
   &MyFont,                                  /* Use our own Font         */
   "A Simple Screen",                        /* Screen Title             */
   NULL,                                     /* Special Screen Gadgets   */
   NULL                                      /* Special CustomBitMap     */
};

struct NewWindow OurWindow =
{
   20, 20,                                   /* LeftEdge and TopEdge      */
   300, 100,                                 /* Width and Height          */
   0, 1,                                     /* DetailPen and BlockPen    */
   NULL,                                     /* IDCMP Flags               */
   ACTIVATE|SMART_REFRESH,                   /* Flags                     */
   NULL, NULL,                               /* Gadget and Image pointers */
   "A Simple Window",                        /* Window Title              */
   NULL,                                     /* Screen pointer            */
   NULL,                                     /* BitMap pointer            */
   0, 0,                                     /* MinWidth and MinHeight    */
   0, 0,                                     /* MaxWidth and MaxHeight    */
   CUSTOMSCREEN                              /* Type of window            */
};

struct Screen *screen;
struct Window *window;
struct GfxBase *GfxBase;
struct IntuitionBase *IntuitionBase;

void main(), cleanexit(), cleanup();



void main()
{
   LONG i;
              /* Method #1 of opening and error testing */

   IntuitionBase=(struct IntuitionBase*)
      OpenLibrary("intuition.library",INTUITION_REV);

   if (IntuitionBase == NULL)
   {
      cleanexit ("Open Intuition Library failed!\n", RETURN_FAIL);
   }

   GfxBase=(struct GfxBase*)OpenLibrary("graphics.library",GRAPHICS_REV);

   if (GfxBase == NULL)
   {
      cleanexit ("Open Graphics Library failed!\n", RETURN_FAIL);
   }

              /* Method #2 of opening and error testing */

   if((screen=(struct Screen*)OpenScreen(&OurScreen))==NULL)
   {
      cleanexit ("Open Screen failed!\n", RETURN_FAIL);
   }

   OurWindow.Screen=screen;

   if((window=(struct Window *)OpenWindow(&OurWindow))==NULL)
   {
      cleanexit ("Open Window failed!\n", RETURN_FAIL);
   }

   Move(window->RPort, 20, 20);
   Text(window->RPort, "Our own TEXT string!", 20);

   for(i=0; i<1000000; i++);

   cleanup();
   exit (RETURN_OK);
}



void cleanexit(s, err)
UBYTE *s;
int err;
{
   if(*s) printf(s);
   cleanup();
   exit(err);
}

void cleanup()
{
   if(window)
   {
      CloseWindow(window);
   }

   if(screen)
   {
      CloseScreen(screen);
   }

   if(GfxBase)
   {
      CloseLibrary(GfxBase);
   }

   if(IntuitionBase)
   {
      CloseLibrary(IntuitionBase);
   }
}
