*
* catch.asm
* Replacement Lattice startup module with PGTB catcher
*
*
	nolist
	INCLUDE "exec/types.i"
	INCLUDE "exec/alerts.i"
	INCLUDE "exec/nodes.i"
	INCLUDE "exec/lists.i"
	INCLUDE "exec/ports.i"
	INCLUDE "exec/libraries.i"
	INCLUDE "exec/tasks.i"
	INCLUDE "exec/execbase.i"
	INCLUDE "libraries/dos.i"
	INCLUDE "libraries/dosextens.i"
	INCLUDE "workbench/startup.i"
	INCLUDE	"intuition/intuition.i"
	INCLUDE "exec/exec_offsets.i"
	INCLUDE	"intuition/intuition_offsets.i"
	INCLUDE "libraries/dos_offsets.i"
	list

	ifd	CAPE
	CSYMFMT
	endc

VERSION 	equ	1
REVISION	equ	5
VBlankOffset	equ	$212		; necessary until I figure what
					; the heck is going on

	xdef	XCEXIT			; exit(code) is standard way to leave C.

	xref	LinkerDB		; linker defined base value
	xref	_BSSBAS 		; linker defined base of BSS
	xref	_BSSLEN 		; linker defined length of BSS

*	library references

	xref	_main			; Name of C program to start with.
	xref	MemCleanup

start:
	movem.l d1-d6/a0-a6,-(a7)
REGSIZE EQU	(6+7)*4
	lea	REGSIZE(a7),A5          ; determine old stack pointer
	move.l	a0,a2			; save command pointer
	move.l	d0,d2			; and command length
	lea	LinkerDB,a4		; load base register

	move.l	_AbsExecBase,a6
	move.l	a6,SysBase(A4)
	move.w	AttnFlags(a6),Environment+2(a4) ; save copy for dump
	move.l	a7,_StackPtr(A4)        ; Save stack ptr
	clr.l	WBenchMsg(A4)

*------ attempt to open Intuition library:
	bsr	openIntui

*------ attempt to open DOS library:
	bsr	openDOS

*------ get the address of our task
	suba.l	a1,a1
	Call	FindTask
	move.l	d0,a3

*------ initialize exception handler
	move.l	#Exception,TC_TRAPCODE(a3)      ; install pointer

*------ are we running as a son of Workbench?
	move.l	pr_CurrentDir(A3),curdir(A4)
	tst.l	pr_CLI(A3)
	beq.s	fromWorkbench

*=======================================================================
*====== CLI Startup Code ===============================================
*=======================================================================
*
* Entry: D2 = command length
*	 A2 = Command pointer
fromCLI:
	moveq	#-1,d0
	move.l	d0,Starter(a4)          ; non-zero means CLI
	move.l	a5,D0			; get top of stack
	move.l	d0,StackTop(a4)         ; ..(save a copy)
	sub.l	4(a5),D0                ; compute bottom
	add.l	#128,D0 		; allow for parms overflow
	move.l	D0,_base(A4)            ; save for stack checking

*------ find command name:
	move.l	pr_CLI(a3),a0
	add.l	a0,a0			; bcpl pointer conversion
	add.l	a0,a0
	move.l	cli_CommandName(a0),a1
	add.l	a1,a1			; bcpl pointer conversion
	add.l	a1,a1

*------ collect parameters:
	move.l	d2,d0			; get command line length
	moveq.l #0,d1
	move.b	(a1)+,d1
	move.l	a1,_ProgramName(A4)
	add.l	d1,d0			; add length of command name
	addq.l	#1,d0			; allow for space after command

	clr.w	-(A7)                   ; set null terminator for command line
	addq.l	#1,D0			; force to even number of bytes
	andi.w	#$fffe,D0		;(round up)
	sub.l	D0,A7			; make room on stack for command line
	subq.l	#2,D0
	clr.w	0(A7,D0)

*------ copy command line onto stack
	move.l	d2,d0			; get command line length
	subq.l	#1,d0
	add.l	d1,d2

copy_line:
	move.b	0(A2,D0.W),0(A7,D2.W)   ; copy command line to stack
	subq.l	#1,d2
	dbf	d0,copy_line
	move.b	#' ',0(a7,d2.w)         ; add space between command and parms
	subq.l	#1,d2

copy_cmd

	move.b	0(a1,d2.w),0(a7,d2.w)   ; copy command name to stack
	dbf	d2,copy_cmd
	move.l	A7,A1
	move.l	A1,-(A7)                ; push command line address
	bra.s	goto_main		; call C entrypoint

*=======================================================================
*====== Workbench Startup Code =========================================
*=======================================================================

fromWorkbench:
	move.l	TC_SPLOWER(a3),_base(A4)        ; set base of stack
	add.l	#128,_base(A4)          ; allow for parms overflow
	move.l	TC_SPUPPER(a3),StackTop(a4)     ; set top of stack

*------ we are now set up.  wait for a message from our starter
	bsr	waitmsg
	move.l	d0,WBenchMsg(a4)
	move.l	d0,-(SP)
*
	move.l	d0,a2			; get first argument
	move.l	sm_ArgList(a2),d0
	beq.s	do_cons
	move.l	DOSBase(a4),a6
	move.l	d0,a0
	move.l	wa_Lock(a0),d1
	move.l	d1,curdir(A4)
	Call	CurrentDir
do_cons:
	move.l	sm_ToolWindow(a2),d1    ; get the window argument
	beq.s	do_main
	move.l	#MODE_OLDFILE,d2
	Call	Open
	move.l	d0,stdin(a4)
	beq.s	do_main
	lsl.l	#2,d0
	move.l	d0,a0
	move.l	fh_Type(a0),pr_ConsoleTask(A3)
do_main:
	move.l	WBenchMsg(A4),a0        ; get address of workbench message
	move.l	a0,-(a7)                ; push argv
	pea	NULL(a4)                ; push argc
	move.l	sm_ArgList(a0),a0       ; get address of arguments
	move.l	wa_Name(a0),_ProgramName(A4)    ; get name of program

*=============================================
*------ common code --------
*=============================================

goto_main:
	lea	_BSSBAS,a3		; get base of BSS
	moveq	#0,d1
	move.l	#_BSSLEN,d0		; get length of BSS in longwords
	bra.s	clr_lp			; and clear for length given
clr_bss move.l	d1,(a3)+
clr_lp	dbf	d0,clr_bss
main	jsr	_main(PC)               ; call C entrypoint
	moveq.l #0,d0			; set successful status
	bra.s	exit2
*

XCEXIT:
	move.l	4(SP),d0                ; extract return code
exit2:
	move.l	d0,-(a7)
	move.l	_ONEXIT(A4),d0          ; exit trap function?
	beq.s	exit3
	move.l	d0,a0
	jsr	(a0)
exit3:
	jsr	MemCleanup(PC)          ; cleanup leftover memory alloc.
	move.l	_AbsExecBase,a6
	move.l	DOSBase(A4),a1
	Call	CloseLibrary		; close DOS library

	move.l	IntuiBase(a4),a1
	Call	CloseLibrary		; close Intuition library

	tst.l	MathBase(A4)
	beq.s	done_1a
	move.l	MathBase(a4),a1
	Call	CloseLibrary		; close ffp math library

done_1a:
	tst.l	MathTransBase(A4)
	beq.s	done_1b
	move.l	MathTransBase(a4),a1
	Call	CloseLibrary		; close ffp transcendental

done_1b:
	tst.l	MathIeeeDoubBasBase(A4)
	beq.s	done_1c
	move.l	MathIeeeDoubBasBase(A4),a1
	Call	CloseLibrary		; close Amiga IEEE library

done_1c:
*------ if we ran from CLI, skip workbench cleanup:
	tst.l	WBenchMsg(A4)
	beq.s	exitToDOS
	move.l	console_dev(A4),d1
	beq.s	done_2
	Call	Close
done_2:
	move.l	stdin(a4),d1
	beq.s	done_4
	Call	Close
done_4:

*------ return the startup message to our parent
*	we forbid so workbench can't UnLoadSeg() us
*	before we are done:
	move.l	_AbsExecBase,A6
	Call	Forbid
	move.l	WBenchMsg(a4),a1
	Call	ReplyMsg

*------ this rts sends us back to DOS:
exitToDOS:
	MOVE.L	(A7)+,D0
	movea.l _StackPtr(a4),SP        ; restore stack ptr
	movem.l (a7)+,d1-d6/a0-a6
	rts

*-----------------------------------------------------------------------
noDOS:
		moveq.l #100,d0
		bra	exit2


*-----------------------------------------------------------------------
* This routine gets the message that workbench will send to us
* called with task id in A3

waitmsg:
		lea	pr_MsgPort(A3),a0       ; our process base
		Call	WaitPort
		lea	pr_MsgPort(A3),a0       ; our process base
		Call	GetMsg
		rts

*-----------------------------------------------------------------------
*  Open the DOS library:

openDOS:
		lea	DOSName(A4),A1
		moveq.l #0,D0
		Call	OpenLibrary
		move.l	D0,DOSBase(A4)
		beq	noDOS
		rts

*-----------------------------------------------------------------------
*  Open the Intuition library:

openIntui:
		lea	IntuiName(A4),A1
		moveq.l #0,D0
		Call	OpenLibrary
		move.l	D0,IntuiBase(A4)
		beq	noDOS
		rts

*-----------------------------------------------------------------------
*  The Exception Handler - catches GURUs and exits (semi)cleanly
Exception:
	move.l	(a7)+,d0                ; get exception # from stack
	move.l	d0,GURUNum		; and save it
	cmpi.l	#3,d0			; ADDRESS or BUS error?
	bgt.s	2$			; no, skip adjustment
	btst	#0,Environment+3	; is it 68010 or 68020?
	beq.s	1$			; 0 means NO
	bset	#7,8(a7)                ; set Rerun flag
	bra.s	2$
1$:
	addq.l	#8,a7			; adjust for 68000
2$:
	move.l	2(a7),d0                ; get PC at crash
	move.l	d0,GURUAddr		; and save it
	move.l	#GURUExit,2(a7)         ; use our own exit point
	rte

*-----------------------------------------------------------------------
*  The Exception exit routine - write 'PGTB' IFF chunk to file
*  'SnapShot.TB' in current directory, then exit to system.

GURUExit:
	movem.l d0-d7/a0-a7,DDump	; save all registers
	move.l	_AbsExecBase,a6 	; make sure we are working with Exec
	Call	GetCC			; safe way - works with all CPUs
	lea	LinkerDB,a4		; make sure we have a valid # in a4
	move.l	d0,Flags(a4)            ; save area
	tst.l	StackPtr(a4)		; if there's something there
	bne	998$			; ...we've been here before!
	lea	TempStore(a4),a0	; calculate addr of TempStore
	move.l	a0,TempAddr(a4)		; ...and save for later access
	move.l	A7Store(a4),d0          ; make sure we have proper TOS
	move.l	d0,StackPtr(a4)         ; ...and save it
	moveq	#0,d0
	move.l	_ProgramName(a4),a0     ; find length of program name
	move.l	a0,PName(a4)
	subq.l	#1,a0
	move.b	(a0),d0
	addq.l	#4,d0			; adjust for shift
	lsr.l	#2,d0
	move.l	d0,NameLen(a4)          ; store length
	add.l	d0,FAILlen(a4)          ; and sub-chunk total

	moveq	#0,d0			; clear d0 for use
	lea	VBlankOffset(a6),a0     ; set up a0 to find correct data
	move.b	(a0)+,d0                ; get just in case
	move.l	d0,VBlankFreq(a4)       ; ...so we can figure what
	move.b	(a0),d0                 ; ...type of machine
	move.l	d0,PowerSupFreq(a4)	; ...we're working on

	lea	start-4(pc),a0          ; get seglist ptr
	moveq	#-1,d0			; always at least 1
2$:
	addq.l	#1,d0
	move.l	(a0),d1                 ; find end of list
	beq.s	3$
	lsl.l	#2,d1			; BPTR!!!!!
	move.l	d1,a0
	bra.s	2$
3$:
	add.l	d0,SegCount(a4)         ; store # of seglist pointers
	lsl.l	#1,d0			; multiply by 2 for longword count
	add.l	d0,FAILlen(a4)          ; and sub-chunk length

	move.l	StackTop(a4),d0         ; get top of stack
	sub.l	StackPtr(a4),d0         ; find number of bytes used
	addq.l	#4,d0			; adjust for longword conversion
	lsr.l	#2,d0			; convert from bytes to long
	move.l	d0,StackLen(a4)         ; and save
	add.l	d0,s2len(a4)            ; and sub-chunk total

	moveq	#0,d0			; PosFlag
	move.l	d0,d1			; NegFlag
	move.l	d0,a0			; 0 means use current window
	lea	IText1(a4),a1           ; Body Text
	lea	IText5(a4),a2           ; Positive Gadget Text
	lea	IText6(a4),a3           ; Negative Gadget Text
	moveq	#1,d2
	lsl.l	#8,d2			; quick way to set Width
	moveq	#76,d3			; Height
	move.l	IntuiBase(a4),a6	; get intuition library pointer
	Call	AutoRequest
	move.l	_AbsExecBase,a6
	tst.l	d0			; save SnapShot?
	beq	999$			; no, just exit

	move.l	DOSBase(a4),a6
	lea	DumpName(a4),a0         ; get name of output file
	move.l	a0,d1
	move.l	#MODE_NEWFILE,d2	; create new file
	Call	Open
	bne.s	4$
	lea	DumpPath(a4),a0         ; if error in current dir, try RAM:
	move.l	a0,d1
	move.l	#MODE_NEWFILE,d2
	Call	Open
	beq	8$			; if error now, nothing to do but die
4$:
	move.l	d0,d5			; save file handle for Write
	move.l	d0,fp(a4)		; ...and in a safe place for later
	move.l	d5,d1			; get file handle
	lea	PGTB(a4),a0             ; first part of fixed
	move.l	a0,d2
	move.l	#chunk_len_1,d3 	; length of first
	Call	Write

	move.l	d5,d1			; get file handle
	move.l	_ProgramName(a4),d2     ; get address of program name
	move.l	NameLen(a4),d3          ; get # longs in program name
	lsl.l	#2,d3			; ..and convert to bytes
	Call	Write

	move.l	d5,d1			; get file handle
	lea	Environment(a4),a0      ; second part of fixed
	move.l	a0,d2
	move.l	#chunk_len_2,d3 	; length of second part
	Call	Write

	lea	start-8(pc),a0		; address of seglist (size of seg)
	move.l	(a0)+,d0		; segsize
	move.l	d0,TempStore+4(a4)	; save it
	move.l	a0,TempStore(a4)	; store first number
	move.l	SegCount(a4),d4
5$:
	move.l	d5,d1			; get file handle
	move.l	TempAddr(a4),d2		; address of write buffer
	moveq	#TempSize,d3		; size of segment pointer
	Call	Write
	move.l	TempStore(a4),a0	; retrieve pointer
	move.l	(a0),d0			; get next seg pointer
	lsl.l	#2,d0			; adjust
	move.l	d0,TempStore(a4)	; ..and save
	move.l	d0,a0
	move.l	-4(a0),d0		; get segsize
	move.l	d0,TempStore+4(a4)	; ...and save it
	subq.l	#1,d4			; done yet?
	bne.s	5$			; no, do next

	move.l	d5,d1			; (get the idea?)
	lea	subREGS(a4),a0          ; third part of fixed
	move.l	a0,d2
	move.l	#chunk_len_3,d3 	; length of third
	Call	Write

	move.l	StackLen(a4),d0		; get length of stack used
	cmpi.l	#8192,d0		; > 8k ?
	bgt.s	6$			; yes, dump two chunks
	move.l	d5,d1
	lea	STAK2(a4),a0            ; whole stack chunk
	move.l	a0,d2
	moveq	#STAK2len,d3		; length of fixed part
	Call	Write

	move.l	d5,d1
	move.l	StackPtr(a4),d2         ; address of stack
	move.l	StackLen(a4),d3         ; # longwords on stack
	lsl.l	#2,d3			; ..converted to bytes
	Call	Write
	bra.s	8$
6$:
	move.l	d5,d1
	lea	STAK3(a4),a0		; top4k chunk
	move.l	a0,d2
	moveq	#STAK3len,d3		; length of fixed part
	Call	Write

	move.l	d5,d1
	move.l	StackTop(a4),d2		; find top of stack
	sub.l	#4096,d2		; find top-4k
	move.l	#4096,d3		; # bytes to write
	Call	Write

	move.l	d5,d1
	lea	STAK4(a4),a0		; bottom4k chunk
	move.l	a0,d2
	moveq	#STAK4len,d3		; length of fixed part
	Call	Write

	move.l	d5,d1
	move.l	StackPtr(a4),d2		; current stack address
	move.l	#4096,d3		; # bytes to write
	Call	Write
8$:
	tst.l	_ONGURU(A4)		; user GURU function?
	beq.s	9$
	move.l	d5,-(sp)
	move.l	d5,d1
	lea	UDAT(a4),a0
	move.l	a0,d2
	move.l	#UDATlen,d3
	Call	Write
	move.l	d5,d1
	moveq	#0,d2			; zero offset
	moveq	#1,d3			; ...from EOF
	Call	Seek
	move.l	d0,SeekStore(a4)
	move.l	_ONGURU(a4),a0
	jsr	(a0)
	addq.l	#4,sp
9$:
	move.l	fp(a4),d5
	move.l	d5,d1
	moveq	#0,d2			; offset from EOF
	moveq	#1,d3			; OFFSET_END
	Call	Seek			; Seek returns OLD position
	move.l	d0,d1
	andi.l	#3,d1			; did user write even longwords?
	beq.s	10$			; Yep!  Nice Human.
	move.l	d1,d6			; Nope, save for later.
	clr.l	TempStore(a4)		; clear temp storage
	move.l	d5,d1
	move.l	TempAddr(a4),d2
	moveq	#4,d3
	sub.l	d6,d3			; find how many NULLs to pad
	Call	Write
	bra.s	9$
10$:
	move.l	d0,TempStore+4(a4)	; save file length
	tst.l	SeekStore(a4)		; did we write UDAT?
	beq.s	11$			; nope!
	sub.l	SeekStore(a4),d0	; find length of UDAT section
	lsr.l	#2,d0			; adjust to longwords
	move.l	d0,TempStore(a4)	; save UDAT length for write
	move.l	d5,d1
	move.l	SeekStore(a4),d2	; find where to write it
	subq.l	#4,d2
	moveq	#-1,d3			; OFFSET_BEGINNING
	Call	Seek
	move.l	d5,d1
	move.l	TempAddr(a4),d2
	move.l	#4,d3
	Call	Write			; write length of UDAT field to file
11$:
	move.l	d5,d1
	moveq	#4,d2			; offset to 'Length' field
	moveq	#-1,d3			; OFFSET_BEGINNING
	Call	Seek
	move.l	TempStore+4(a4),d0	; get file length back
	subq.l	#8,d0			; adjust total length
	lsr.l	#2,d0			; adjust to longwords
	move.l	d0,TempStore(a4)	; save for write
	move.l	d5,d1
	move.l	TempAddr(a4),d2
	move.l	#4,d3
	Call	Write			; write 'Length' field
998$:
	move.l	fp(a4),d1
	beq.s	999$
	move.l	DOSBase(a4),a6
	Call	Close
999$:
	move.l	_AbsExecBase,a6
	move.l	#999,d0
	bra	exit2

	section _MERGED,DATA
*
	xdef	NULL,SysBase,LoadAddress,console_dev,WBenchMsg,DOSBase
	xdef	curdir,_mbase,_mnext,_msize,_tsize
	xdef	_oserr,_OSERR,_FPERR,_SIGFPE,_ONERR,_ONEXIT,_ONBREAK,_ONGURU
	xdef	_SIGINT,_ECS
	xdef	_ProgramName,_StackPtr,_base
	xdef	MathIeeeDoubBasBase
*
NULL		dc.l	0		;
_mbase		dc.l	0		; base of memory pool
_mnext		dc.l	0		; next available memory location
_msize		dc.l	0		; size of memory pool
_tsize		dc.l	0		; total size?
_base		dc.l	0		; base of stack
_StackPtr	dc.l	0
_oserr:
_OSERR		dc.l	0
_FPERR		dc.l	0
_SIGFPE 	dc.l	0
_SIGINT 	dc.l	0
_ONERR		dc.l	0
_ONEXIT 	dc.l	0
_ONBREAK	dc.l	0
_ONGURU		dc.l	0
_ECS		dc.l	0		; extended character set flag
curdir		dc.l	0
console_dev	dc.l	0
SysBase 	dc.l	0
LoadAddress	dc.l	0		; program load address
WBenchMsg	dc.l	0
stdin		dc.l	0
_ProgramName	dc.l	0
DOSBase 	dc.l	0
IntuiBase	dc.l	0
MathBase	dc.l	0
MathTransBase	dc.l	0
MathIeeeDoubBasBase dc.l       0
DOSName 	dc.b	'dos.library',0
IntuiName	dc.b	'intuition.library',0
fp		dc.l	0		; save SnapShot file pointer
DumpPath	dc.b	'RAM:'
DumpName	dc.b	'SnapShot.TB',0
SeekStore	dc.l	0
TempAddr	dc.l	0		; Storage for &TempStore
TempStore	dc.l	0,0		; Temporary storage for BPTR -> APTR
TempSize	equ	*-TempStore

TAttr:				; Text attributes for font
	dc.l	TName		; name of font
	dc.w	TOPAZ_EIGHTY	; font size
	dc.b	FS_NORMAL	; font style
	dc.b	0		; font preferences
TName:
	dc.b	'topaz',0

IText1:				; Text definitions for AutoReq call
	dc.b	3,0,RP_JAM1,0	; front & back pens, drawmode and filler byte
	dc.w	6,4		; XY origin relative to container TopLeft
	dc.l	TAttr		; font pointer or NULL for default
	dc.l	ITextText1	; pointer to text
	dc.l	IText2		; next IntuiText structure
ITextText1:
	dc.b	'Program:',0
	cnop 0,2
IText2:
	dc.b	3,0,RP_JAM1,0
	dc.w	78,4
	dc.l	TAttr
PName	dc.l	0
	dc.l	IText3
	cnop	0,2
IText3:
	dc.b	3,0,RP_JAM1,0
	dc.w	55,16
	dc.l	NULL
	dc.l	ITextText3
	dc.l	IText4
ITextText3:
	dc.b	'I caught a GURU!',0
	cnop 0,2
IText4:
	dc.b	3,0,RP_JAM1,0
	dc.w	20,28
	dc.l	TAttr
	dc.l	ITextText4
	dc.l	NULL
ITextText4:
	dc.b	'Should I make a SnapShot?',0
	cnop 0,2
IText5:
	dc.b	3,0,RP_JAM1,0
	dc.w	6,4
	dc.l	TAttr
	dc.l	ITextText5
	dc.l	NULL
ITextText5:
	dc.b	'YES',0
	cnop 0,2
IText6:
	dc.b	3,0,RP_JAM1,0
	dc.w	7,4
	dc.l	TAttr
	dc.l	ITextText6
	dc.l	NULL
ITextText6:
	dc.b	'NO',0
	cnop 0,2

*--------------------------------------------------------------------------
* New IFF chunk format -
*	PGTB = Program Traceback, header for chunk
*	FAIL = reason for and environment of crash
*	REGS = registers at time of crash, including PC and CCR
*	VERS = version, revision, name of this program
*	STAK = ENTIRE stack at time of crash or, alternately,
*		the top and bottom 4k if the stack used is > 8k
*	UDAT = optional user data dump (if _ONGURU is set to a
*		function pointer in the user's program)
*--------------------------------------------------------------------------

PGTB		dc.b	'PGTB'
Length		dc.l	0		; length of chunk (in longwords)

subFAIL 	dc.b	'FAIL'
FAILlen 	dc.l	9
NameLen 	dc.l	0		; length of program name
chunk_len_1	equ	*-PGTB
Environment	dc.l	0		; CPU (, Math)
VBlankFreq	dc.l	0		;    PAL = 50, NTSC = 60 (approx.)
PowerSupFreq	dc.l	0		; Europe = 50,	USA = 60 (approx.)
Starter 	dc.l	0		; 0 = WB, -1 = CLI
GURUNum 	dc.l	0		; cause of crash (GURU #)
SegCount	dc.l	1		; # hunks in seglist
chunk_len_2	equ	*-Environment

subREGS 	dc.b	'REGS'          ; REGS - register storage field
REGSlen 	dc.l	18
GURUAddr	dc.l	0		; PC at time of crash
Flags		dc.l	0		; Condition Code Register (CCR)
DDump		dc.l	0,0,0,0,0,0,0,0 ; data registers
ADump		dc.l	0,0,0,0,0,0,0	; address registers
A7Store 	dc.l	0

subVERS 	dc.b	'VERS'          ; VERS - program version field
	 	dc.l	5
	 	dc.l	VERSION 	; version #
		dc.l	REVISION	; revision #
		dc.l	2		; length of name of program
		dc.b	'catch.o',0     ; name

subSTAK 	dc.b	'STAK'          ; STAK - stack field
STAKlen 	dc.l	4
Type		dc.l	0		; 0 = Info
StackTop	dc.l	0		; top of stack pointer
StackPtr	dc.l	0		; current Stack Pointer
StackLen	dc.l	0		; # bytes used on stack
chunk_len_3	equ	*-subREGS

STAK2		dc.b	'STAK'
s2len		dc.l	1		; length of subtype
		dc.l	1		; 1 = whole stack
STAK2len	equ	*-STAK2

STAK3		dc.b	'STAK'
		dc.l	1025
		dc.l	2		; 2 = top 4k of stack
STAK3len	equ	*-STAK3

STAK4		dc.b	'STAK'
		dc.l	1025
		dc.l	3		; 3 = bottom 4k of stack
STAK4len	equ	*-STAK4

UDAT		dc.b	'UDAT'
		dc.l	0
UDATlen		equ	*-UDAT
	END

