/* auToolDemo1.c */

/* #define DEBUG 1 */

#include "types.h"
#include "memory.h"
#include "audio.h"
#include "vdk:atools.c"


/* 32 samples shown here... sample rate is 9956 samples per second. */

WORD tap[] = {
	87,27,226,21,247,60,34,194,7,25,2,41,6,213,
	41,63,12,236,27,251,44,23,-1,+1,-1,+1,
	-1,+1,-1,+1,-1,+1
};

char *ramtap;

WORD song[] = {
	24, 200, 32,
	17, 400, 32,
	1,  400,  0,
	19, 200, 32,
	21, 400, 32,
	1,  400,  0,
	17, 200, 32,
	19, 200, 32,
	21, 200, 32,
	19, 200, 32,
	18, 200, 32,
	19, 200, 32,
	24, 400, 32,
	1,  600,  0,
	24, 200, 32,
	17, 400, 32,
	19, 200, 32,
	21, 400, 32,
	 1, 600,  0,
	17, 200, 32,
	19, 200, 32,
	21, 200, 32,
	19, 200, 32,
	18, 200, 32,
	19, 200, 32,
	24, 400, 32,
	 1, 600,  0,
	
	26, 200, 32,
	24, 400, 32,
	1,  400,  0,
	26, 200, 32,
	23, 400, 32,
	1,  400,  0,
	26, 200, 32,
	22, 400, 32,
	1,  400,  0,
	26, 200, 32,
	21, 400, 32,
	 1, 600,  0,
	
	14, 200, 32,
	19, 200, 32,
	21, 200, 32,
	19, 200, 32,
	17, 200, 32,
	14, 200, 32,
	19, 200, 32,
	21, 200, 32,
	19, 200, 32,
	17, 200, 32,
	14, 200, 32,
	19, 600, 32,
	24, 400, 32,
	 1, 400,  0,

	24, 200, 32,
	17, 400, 32,
	1,  400,  0,
	19, 200, 32,
	21, 400, 32,
	1,  400,  0,
	17, 200, 32,
	19, 200, 32,
	21, 200, 32,
	19, 200, 32,
	18, 200, 32,
	19, 200, 32,
	24, 400, 32,
	1,  600,  0,
	24, 200, 32,
	17, 400, 32,
	19, 200, 32,
	21, 400, 32,
	 1, 600,  0,
	17, 200, 32,
	19, 200, 32,
	21, 200, 32,
	19, 200, 32,
	18, 200, 32,
	19, 200, 32,
	24, 400, 32,
	 1, 600,  0,
	
	26, 200, 32,
	24, 400, 32,
	1,  400,  0,
	26, 200, 32,
	23, 400, 32,
	1,  400,  0,
	26, 200, 32,
	22, 400, 32,
	1,  400,  0,
	26, 200, 32,
	21, 400, 32,
	 1, 600,  0,
	
	14, 200, 32,
	19, 200, 32,
	21, 200, 32,
	19, 200, 32,
	17, 200, 32,
	14, 200, 32,
	19, 200, 32,
	21, 200, 32,
	19, 200, 32,
	17, 200, 32,
	14, 200, 32,
	19, 600, 32,
	17, 200, 32,
	99 };

main()
{
   LONG i,j,k, channel, offset, error;
   LONG mynote;

   struct MsgPort *myport;   /* CHANGE from article */
   char *tapcopy;

   myport = InitAudio();   /* now returns address of message port */
   if(myport == 0) 
   {
	printf("Problem in InitAudio!");
	FinishAudio(myport);
	exit(20);
   }

   ramtap = (char *)AllocMem(32, MEMF_CHIP);
   if (ramtap == NULL)
   {
	/* SAMPLED SOUND must be in chip ram. */

	printf("No chip mem for tap sound!");
	FinishAudio(myport);
	exit(20);
   }

   /* copy the tap sound to chip ram. */

   tapcopy = ramtap;
   for(i=0; i<32; i++);
   {
	*tapcopy = tap[i];
	tapcopy++;
   }

   for(i=0; i<4; i++) 
   {   
      channel = GetChannel(-1);
      if(channel == -1)
      {
	   printf("cannot get a channel!\n");
	   FinishAudio(myport);
  	   exit(20);
      }
   }

   offset = 0;	/* for tuning the song */

   /* song array has notenum, duration, volume times number of songs */

/* KEVIN - here is the main music loop...
 *         channel 0 gets one tap sound per note in
 *         the song[] array.
 *         channel 1 gets the song note number, duration, and volume.
 *
 * To sync your graphics to the notes, simply insert a call to draw
 * your next image immediately before the call to MayGetNote, since
 * this puts THIS loop to sleep until the note stops playing.
 */


   i=0;
   for(;;)
   {
   /*  (channel, note, waveform, vol, duration, priority,messageport, id) */

      if(song[i] == 99) 
      {
	PlayNote(1, (long)0, w2, 0, 1, 0, myport, 99 );
	break;
      }

      j = i+2;  k = i+1;

      error = PlaySamp(0, 357, ramtap, 62, 1, 0, 0, 0, 32);

      error = PlayNote(1, (long)(offset + song[i]), 
		w2,  (long)song[j], (long)song[k], (long)0, myport, (long)0);

      /* The above two calls QUEUE up a note for each channel independently.
       * The call to PlaySamp is written to be an independent queue.  
       * It returns nothing.
       * 
       * The call to PlayNote includes the "myport" parameter to guarantee
       * that there will be something there for MayGetNote to wait for.
       * When the associated parameter below is FALSE, it does NOT sleep.
       * Since is it true, it sleeps waiting for a note and returns the
       * identifier (id) value.  I don't care what value, just want to sleep.
       */

      /* INSERT call to DoNextGraphics() HERE */

      mynote = MayGetNote(myport, TRUE);  /* GO TO SLEEP, 
					   wait for note to BEGIN to play */

      /* OR ... INSERT call to DoNextGraphics() HERE, whichever works best */
		
      i = i+3;
   }

   mynote = MayGetNote(myport, TRUE);  /* YES, wait for it to begin to play! */


   FinishAudio(myport);   /* NEW parameter for FinishAudio */

   if(ramtap) FreeMem(ramtap, 32);

   return(0);
}         /* end of main() */

/* NOTE - memory allocation for audiotools checked ok last time.  Not
 * checked this time but SHOULD exit cleanly as per BADGE rules.  Hope
 * you have good luck with it.   Regards,  Rob Peck.
 *
 * P.S. You may want to adjust the timing on the notes a little bit;
 * can't help the sour one in the middle, don't know how to fix it.
 * If more time, can certainly find a way.  
 */
