/* auToolDemo1.c */

/* #define DEBUG 1 */

#include "exec/types.h"
#include "exec/memory.h"
#include "devices/audio.h"
#include "ram:audiotools3.c"

BYTE *noise;

main()
{
   LONG i, channel, error, note;

   struct MsgPort *myport;   /* CHANGE from article */

   noise = (BYTE *)AllocMem(1024, MEMF_CHIP);

   for(i=0; i<1024; i++)
   {
	/* Use a PseudoRandom number generator to get white noise */

	noise[i] = 127 - RangeRand(256);
   } 


   myport = InitAudio();   /* now returns address of message port */
   if(myport == 0) 
   {
	printf("Problem in InitAudio!");
	FinishAudio(myport);
   }
   for(i=0; i<4; i++) 
   {   
      channel = GetChannel(-1);
      if(channel == -1)
      {
	   printf("cannot get a channel!\n");
	   FinishAudio(myport);
      }

      error = StopChannel(channel);
      if(error) 
      {  
	 printf("error in stopping channel = %ld\n",error);
         FinishAudio(myport);
      }
   }
   /*  (channel, note, waveform, vol, duration, priority,messageport, id) */

   for(i=0; i<49; i++)
   {
      /* frequency of "zero" is not useful */

      PlayFreq(0, (i+1)*10, w1, 32, 125, 0, 0, 0); /* all notes, 1/8 sec. */
      PlayNote(1, 95-i,     w2, 32, 125, 0, 0, 0); 
   }

   /* SMACK IN THE MIDDLE HERE, INSTALL TEST OF MESSAGING */
   /* cause it to flash the screen when this note begins to play */
   /* Make the note distinctive so we can tell for sure */

   PlayNote(1, 3,           w3, 63, 500, 0, myport, 3);  /* very LOUD and low */
   
   for(i=50; i<95; i++)
   {
      PlayFreq(0, (i+1)*10, w1, 32, 125, 0, 0, 0); /* all notes, 1/8 sec. */
      PlayNote(1, 95-i,     w2, 32, 125, 0, 0, 0); 
   }

   for(i=0; i<4; i++)
   {   
	error = StartChannel(i);
        if(error)  
	{
		printf("error starting channel = %ld\n",error);
		FinishAudio(myport);
	}
   }

   /* Now SLEEP while waiting for that note to play */

   printf("Going to sleep now - the prioritized note will wake me up\n");

   note = MayGetNote(myport, TRUE);	/* FALSE means don't sleep */

   printf("\n\n\n****************************************************\n");
   printf("Hey!  Note I identified as: %ld just started to play\n",note);
   printf("\n****************************************************\n\n\n");

   /* When we hit the PlayNote, it calls GetIOB, which in turn
    * begins to remove iob's from the reply port, freeing them
    * for future use.  You might consider changing the ReEmployIOB
    * routine to simply free 1 or 10 or whatever number, just so 
    * you could begin to play another note before ALL of the already
    * played note's iob's had been freed.  But when DEBUG is turned
    * off, the freeing goes a lot faster.
    */

   Delay(250);	/* waits 5 seconds so that all of these synchronize */

   PlayNote(0, 23, w1, 32, 2000, 0, 0, 0);
   PlayNote(1, 27, w2, 32, 2300, 0, 0, 0);
   PlayNote(2, 30, w3, 32, 2600, 0, 0, 0);
   PlayNote(3, 35, w1, 32, 2900, 0, 0, 0);

   printf("Finally, some noise, using PlaySamp\n");
   PlaySamp(0,    327,    &noise[0],  32,     6000,  0,    0,    0,   1024 );
   /*    chan, samplrate, what2play, volume, 6.0sec, pri, msgpt, id, length */

   Delay(450);	/* Waits 9 seconds after letting the last note begin
		 * (because last note is 2900/1000ths long).
		 * If you take out this delay, you'll see that
		 * FinishAudio means FINISH AUDIO... it cuts off
		 * the notes right in the middle if necessary!
		 */


   FinishAudio(myport);   /* NEW parameter for FinishAudio */
   FreeMem(noise, 1024);

   printf("Done!\n");
   return(0);
}         /* end of main() */
