/******************************************************************************
*
*   Source Control
*   --------------
*   $Header: propjoy.c,v 34.1 85/11/24 17:59:44 bart Exp $
*
*   $Locker:  $
*
*   $Log:   propjoy.c,v $
*   Revision 34.1  85/11/24  17:59:44  bart
*   be system compatible
*   
*   Revision 34.0  86/11/21  16:35:51  bart
*   added to rcs for updating
*
* Copyright (c) 1988 Commodore-Amiga, Inc.
* 
* Executables based on this information may be used in software
* for Commodore Amiga computers.  All other rights reserved.
* 
* This information is provided "as is"; no warranties are made.
* All use is at your own risk, and no liability or responsibility is assumed.
*
******************************************************************************/

/* main.c - test program for add/rem tof task - bart - 05.19.86 */
/* propjoy.c modified program for proportional controller - bart - 11.21.86 */

#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/execbase.h>
#include <exec/execname.h>

#include <graphics/gfxbase.h>
#include <graphics/graphint.h>

#include <hardware/cia.h>
#include <hardware/custom.h>
#include <hardware/intbits.h>

#include <resources/potgo.h>

#define V1_POINT_2  33

#define NUM_SERVERS 2

#define MAX_COUNT   (UWORD)~1	    /* do it for a while */

/* use system defined hard addresses */

extern struct Custom custom;

/* use system defined addresses for potgo and pot1dat */

#define POTGO	    &custom.potgo
#define POT0DAT	    &custom.pot0dat
#define POT1DAT	    &custom.pot1dat

/* vertical blank interrupt server priority   */

#define HIGHINTPRI 127L	    /* needs to be replaced with priority relative */
#define LOWINTPRI -127L	    /* needs to be replaced with priority relative */

/* bit number defines for potgo ... */

#define START_B	    0	

#define DATRX_B	    8	
#define DATRY_B	    10

#define DATLX_B	    12	
#define DATLY_B	    14

/* masks ... */

#define START_F	    (1L << START_B)
#define DATRX_F	    (1L << DATRX_B)
#define DATRY_F	    (1L << DATRY_B) 
#define DATLX_F	    (1L << DATLX_B)
#define DATLY_F	    (1L << DATLY_B) 

#define RPOTX	    (START_F | DATRX_F) 
#define RPOTY	    (START_F | DATRY_F) 
#define RPOTXY	    (START_F | DATRX_F | DATRY_F) 

#define LPOTX	    (START_F | DATLX_F) 
#define LPOTY	    (START_F | DATLY_F) 
#define LPOTXY	    (START_F | DATLX_F | DATLY_F) 

struct ExecBase *ExecBase = NULL;
struct GfxBase *GfxBase = NULL;
struct PotgoBase *PotgoBase = NULL;

/* global storage for potdat */

UWORD oldbits = NULL;
UWORD potbits = NULL;
ULONG potdat = NULL;

/* create server-task to read the proportional joysticks,*/ 
/* update potdat, and then poke potgo to start next data read */

/* reserve space for the interrupt servers */
struct Isrvstr server[NUM_SERVERS] = {NULL};

first_server(i)
int i;
{
    /* read previous proportional joystick values */
    potdat = *(ULONG *)POT0DAT;

    /* poke potgo, restore old bits */
    WritePotgo(oldbits,((~1)<<8)|oldbits);

    /* be nice -- let other servers run, too */
    return(NULL);
}

second_server(i)
int i;
{
    /* poke potgo, start prop joystick read  */
    WritePotgo(potbits,((~1)<<8)|potbits);

    /* be nice -- let other servers run, too */
    return(NULL);
}


main()
{
    LONG error = FALSE;
    struct Isrvstr *iserver[NUM_SERVERS];
    LONG i;

    /* set server priorities */ 
    server[0].is_Node.ln_Pri = HIGHINTPRI;  
    server[1].is_Node.ln_Pri = LOWINTPRI;   

    /* set up server pointers */
    iserver[0] = &server[0];
    iserver[1] = &server[1];

    if((ExecBase = (struct ExecBase *)OpenLibrary(EXECNAME,V1_POINT_2)) != NULL)
    {
	if((GfxBase = (struct GfxBase *)
	    OpenLibrary("graphics.library",V1_POINT_2)) != NULL)
	{

	    if((PotgoBase = OpenResource(POTGONAME,V1_POINT_2)) != NULL)
	    {

		/* remember currently used bits */
		oldbits = ~(AllocPotBits(~1));

		/* restore previous state of bit allocation */
		FreePotBits(~oldbits);

		/* now attempt to allocate start potbit */
		potbits = AllocPotBits(START_F);

		Forbid();   

		/* add interrupt servers */

		AddTOF(iserver[0],first_server,0);

		AddTOF(iserver[1],second_server,1);

		Permit();

		/* loop until done */

		for(i=0; i < MAX_COUNT; i++)
		{
		    /* wait for server to update pot values */
		    WaitTOF();

		    /* only output information once every second */
		    if(!(i %  ExecBase->VBlankFrequency))
		    {
		    }
		}

		Forbid();   

		for(i=0; i < NUM_SERVERS; i++)
		{
		    RemTOF(iserver[i]);
		}

		Permit();

		/* free potbits */

		FreePotBits(potbits);

		CloseLibrary(GfxBase);
	    }
	    else
	    {
		error = TRUE;
	    }
	}
	else
	{
		error = TRUE;
	}

	CloseLibrary(ExecBase);

    }
    else
    {
	error = TRUE;
    }

    /* return error code */
    exit(error);
}
