/*********************************************************************/
/*                                                                   */
/*                     Copyright (c) 1985                            */
/*                    Commodore-Amiga, Inc.                          */
/*                    All rights reserved.                           */
/*                                                                   */
/*     No part of this program may be reproduced, transmitted,       */
/*     transcribed, stored in retrieval system, or translated        */
/*     into any language or computer language, in any form or        */
/*     by any means, electronic, mechanical, magnetic, optical,      */
/*     chemical, manual or otherwise, without the prior written      */
/*     permission of:                                                */
/*                     Commodore-Amiga, Inc.                         */
/*                     983 University Ave #D                         */
/*                     Los Gatos, CA. 95030                          */
/*                                                                   */
/*********************************************************************/

/*********************************************************************/
/*                                                                   */
/*  Program name:  idio                                              */
/*                                                                   */
/*  Purpose:  To provide standard input device interface routines    */
/*                                                                   */
/*********************************************************************/

#include "exec/types.h"
#include "exec/nodes.h"
#include "exec/lists.h"
#include "exec/ports.h"
#include "exec/interrupts.h"
#include "exec/io.h"

#include "../inputevent.h"
#include "../input.h"

struct IOStdReq inputIO = 0;
struct IOStdReq inputREADIO = 0;
struct MsgPort inputMsgPort = 0;
UBYTE inputReadChar = 0;

int IDOpen()
{
	int error;
		
/* Open the input device */
	if ((error = OpenDevice("input.device", 0, &inputIO, 0)) != 0)
	{
		kprintf("IDInit OpenDevice error: %d.\n", error);
		return(error);
	}

/* Set up the message port in the I/O request */
	inputMsgPort.mp_Node.ln_Type = NT_MSGPORT;
	inputMsgPort.mp_Node.ln_Name = "IDIO";
	inputMsgPort.mp_Flags = 0;
	inputMsgPort.mp_SigBit = AllocSignal(-1);
	inputMsgPort.mp_SigTask = (struct Task *) FindTask((char *) NULL);
	AddPort(&inputMsgPort);
	inputIO.io_Message.mn_ReplyPort = &inputMsgPort;

	return(0);
}


IDClose()
{
	CloseDevice(&inputIO);
	FreeSignal(inputMsgPort.mp_SigBit);
	RemPort(&inputMsgPort);
}


IDStop()
{
	inputIO.io_Command = CMD_STOP;
	DoIO(&inputIO);
}


IDStart()
{
	inputIO.io_Command = CMD_START;
	DoIO(&inputIO);
}


IDAddHandler(handler)
struct Interrupt *handler;
{
	inputIO.io_Command = IND_ADDHANDLER;
	inputIO.io_Data = handler;
	inputIO.io_Length = sizeof(struct Interrupt);
	DoIO(&inputIO);
}


IDRemHandler(handler)
struct Interrupt *handler;
{
	inputIO.io_Command = IND_REMHANDLER;
	inputIO.io_Data = handler;
	inputIO.io_Length = sizeof(struct Interrupt);
	DoIO(&inputIO);
}


IDWriteEvent(event)
struct InputEvent *event;
{
	inputIO.io_Command = IND_WRITEEVENT;
	inputIO.io_Data = event;
	inputIO.io_Length = sizeof(struct InputEvent);
	DoIO(&inputIO);
}


IDSetRepeat(thresh, period)
struct timeval *thresh;
struct timeval *period;
{
	inputIO.io_Command = IND_SETTHRESH;
	inputIO.io_Data = thresh;
	inputIO.io_Length = sizeof(struct timeval);
	DoIO(&inputIO);
	inputIO.io_Command = IND_SETPERIOD;
	inputIO.io_Data = period;
	inputIO.io_Length = sizeof(struct timeval);
	DoIO(&inputIO);
}


IDMPort(port)
UBYTE port;
{
	inputIO.io_Command = IND_SETMPORT;
	inputIO.io_Data = &port;
	inputIO.io_Length = 1;
	DoIO(&inputIO);
}
