/* vint.c -- video interrupts
 * Copyright (c) 1988, I and I Computing, and Commodore-Amiga, Inc.
 *
 *
 * Executables based on this information may be used in software
 * for Commodore Amiga computers.  All other rights reserved.
 *
 * This information is provided "as is"; no warranties are made.
 * All use is at your own risk, and no liability or responsibility is assumed.
 */

#include "sysall.h"

#define VBLANK_TOO	0		/* do we want vblank interrupt	*/

/* don't change this around without modifying intSignal() to suit	*/
struct SigStuff	{
	LONG		ss_Signals;		/* send these signals ...	*/
	struct Task	*ss_Task;		/* ... to this task.		*/
}	sigstuff;

struct Interrupt	vidint1;		/* hang this off of vertical blank		*/
struct Interrupt	vidint2;		/* hang this off of copper interrupt	*/

VOID intSignal();		/* interrupt server, signals me	*/

installHandlers( signum )
int		signum;			/* handlers will post this signal	*/
{
	/* fill out my little bundle o' info	*/
	sigstuff.ss_Signals = (long) 1 << signum;
	sigstuff.ss_Task = FindTask( 0L );

	/* set up interrupt node	*/
	vidint1.is_Node.ln_Pri = 0;
	vidint1.is_Node.ln_Name = NULL;
	vidint1.is_Data = (APTR) &sigstuff;
	vidint1.is_Code = intSignal;

	vidint2 = vidint1;		/* another copy, for a different server chain	*/

#if VBLANK_TOO
	AddIntServer( (long) INTB_VERTB, &vidint1 );
#endif
	AddIntServer( (long) INTB_COPER, &vidint2 );
}

removeHandlers()
{
#if VBLANK_TOO
	RemIntServer( (long) INTB_VERTB, &vidint1 );
#endif
	RemIntServer( (long) INTB_COPER, &vidint2 );
}
