/* ucop.c -- set up user copper list for custom viewports
 * Copyright (c) 1988, I and I Computing, and Commodore-Amiga, Inc.
 *
 * Executables based on this information may be used in software
 * for Commodore Amiga computers.  All other rights reserved.
 *
 * This information is provided "as is"; no warranties are made.
 * All use is at your own risk, and no liability or responsibility is assumed.
 */

#include "sysall.h"

/*
 * small version of what can be found in cpr.c.
 * creates a small user copper list which causes an
 * interrupt near the bottom of my viewport.
 */
struct UCopList	*
createUCop( vpos, hpos )
{
	struct UCopList	*ucl;

	/* I will free this myself	*/
	if ( !(ucl = AllocMem( (LONG) sizeof (struct UCopList), 
		(LONG) MEMF_CHIP | (LONG) MEMF_CLEAR) )) return ( NULL );

	CINIT( ucl, 10L );
	CWAIT( ucl, (long) vpos, (long) 0 );
	/* note that intreq bit 15 is set to indicate that 
	 * i want to *set* bit 4, the copper interrupt
	 */
	CMOVE( ucl, custom.intreq, (long) (1<<15) | (1<<4) );
	CEND( ucl );

	return ( ucl );
}


/* free the UCL allocated above	*/
freeUCop( ucl )
struct UCopList *ucl;
{
	if ( ucl )
	{
		FreeCopList( ucl->FirstCopList );
		FreeMem( ucl, (LONG) sizeof (struct UCopList) );
	}
}
