/* oscreen.c -- screen, window, menus, ... for overscan demo
 * Copyright (c) 1988, I and I Computing and Commodore-Amiga, Inc.
 *
 *
 * Executables based on this information may be used in software
 * for Commodore Amiga computers.  All other rights reserved.
 *
 * This information is provided "as is"; no warranties are made.
 * All use is at your own risk, and no liability or responsibility is assumed.
 */

#include "sysall.h"
#include "oscan.h"

#define NSWIDTH  	HUGEWIDTH
#define NSHEIGHT 	HUGEHEIGHT

#define NSVIEWMODES	( HIRES | LACE )
#define NSTYPE		( CUSTOMSCREEN | CUSTOMBITMAP )

struct Screen *
getScreen( bmap )
struct BitMap	*bmap;
{
	struct NewScreen	ns;

	ns.LeftEdge =	ns.TopEdge =	0;
	ns.Width =	NSWIDTH; ns.Height =	NSHEIGHT;
	ns.Depth =	bmap->Depth;
	ns.DetailPen =	0;	ns.BlockPen =	1;
	ns.ViewModes =	NSVIEWMODES;
	ns.Type =		NSTYPE;
	ns.Font =		NULL;
	ns.DefaultTitle =	(UBYTE *) " Huge Test Screen ";
	ns.Gadgets = 	NULL;
	ns.CustomBitMap = bmap;

	return ( OpenScreen( &ns ) );
}

struct TextAttr myfont = { (UBYTE *) "topaz.font", 8, 0, 0};
/* STRING GADGETS */
#define SGTOP0	(80)
#define SGTOP1	(100)
#define SGLEFT	(250)
#define SGWIDTH	(100)
#define SGHEIGHT (10)
#define GTLEFT	(-120)
#define SGBUFF	(6)
#define SGACTIV	(RELVERIFY | STRINGRIGHT | LONGINT)

UBYTE	oribuff0[ 100 ];
UBYTE	oribuff1[ 100 ];

struct IntuiText oritext[] = {
	{1, 0,JAM2,SGWIDTH + 20, 2, &myfont, oribuff0,NULL},
	{1, 0,JAM2,SGWIDTH + 20,2, &myfont, oribuff1,NULL},
};

struct IntuiText sgtext[] = {
	{1, 0,JAM2,GTLEFT,2, &myfont,(UBYTE *) "View DxOffset:",&oritext[0]},
	{1, 0,JAM2,GTLEFT,2, &myfont,(UBYTE *) "View DyOffset:",&oritext[1]},
};

UBYTE	sgbuff0[ SGBUFF ];
UBYTE	sgbuff1[ SGBUFF ];

UBYTE	unbuff0[ SGBUFF ];
UBYTE	unbuff1[ SGBUFF ];

struct StringInfo mysi[] = {
	{sgbuff0, unbuff0, 0, SGBUFF, 0},
	{sgbuff1, unbuff1, 0, SGBUFF, 0},
};

/* box around string gadgets	*/
SHORT	mypoints[] = {
	-1,-2,
	SGWIDTH,-2,
	SGWIDTH,SGHEIGHT,
	-1,SGHEIGHT,
	-1,-2,
};
struct Border mysgborder = { 0,0,1,0,JAM2,5,mypoints,NULL};

struct Gadget	mysg[] = {
	{ &mysg[1], SGLEFT, SGTOP0, SGWIDTH, SGHEIGHT, GADGHCOMP, SGACTIV, STRGADGET,
		(APTR) &mysgborder, NULL, &sgtext[0], 0, (APTR) &mysi[0], 0},
	{   NULL, SGLEFT, SGTOP1, SGWIDTH, SGHEIGHT, GADGHCOMP, SGACTIV, STRGADGET,
		(APTR) &mysgborder, NULL, &sgtext[1], 0, (APTR) &mysi[1], 0},
};

/* MENUS */
#define MFLAGS  (ITEMTEXT | ITEMENABLED | HIGHCOMP)
#define	MIHT	(10)	/* menu item height */

/* menu item text	*/
struct IntuiText mitext[] = {
	{0,1,JAM2,2,0, &myfont,(UBYTE *) "View Shift",NULL},
	{0,1,JAM2,2,0, &myfont,(UBYTE *) "Cheat, too",NULL},
	{0,1,JAM2,2,0, &myfont,(UBYTE *) "Normal",NULL},
	{0,1,JAM2,2,0, &myfont,(UBYTE *) "Quit",NULL},
};

struct MenuItem myi[] = {
{&myi[1], 2, 	0,		100, MIHT, MFLAGS, 0, (APTR) &mitext[0],NULL, 0, NULL},
{&myi[2], 2, 	MIHT,	100, MIHT, MFLAGS, 0, (APTR) &mitext[1],NULL, 0, NULL},
{&myi[3], 2,   2*MIHT,	100, MIHT, MFLAGS, 0, (APTR) &mitext[2],NULL, 0, NULL},
{ NULL,   2,   3*MIHT,	100, MIHT, MFLAGS, 0, (APTR) &mitext[3],NULL, 0, NULL},
};

struct Menu	mymenu[] = {
	{ NULL, 0, 0, 100, 10, MENUENABLED, " Action ", myi},
};

struct Window	*
getWindow( screen )
struct Screen *screen;
{
	struct NewWindow	nw;
	struct Window		*window;
	extern ULONG 	iflags;
	extern ULONG 	flags;

	nw.LeftEdge =	0;
	nw.TopEdge =	screen->BarHeight;
	nw.Width =		screen->Width;
	nw.Height =		screen->Height - nw.TopEdge;
	nw.DetailPen	= 0;	nw.BlockPen =	1;
	nw.IDCMPFlags =	iflags;
	nw.Flags = 		flags;
	nw.FirstGadget = mysg;
	nw.CheckMark =	NULL;
	nw.Title = 		NULL;
	nw.Screen =		screen;
	nw.BitMap = 	NULL;
	nw.Type =		CUSTOMSCREEN;

	if ( window = OpenWindow( &nw ) )
	{
		SetMenuStrip( window, mymenu );
	}

	return ( window );
}
