/* huge.c -- get huge bitmap for overcan experiments
 * Copyright (c) 1988, I and I Computing and Commodore-Amiga, Inc.
 *
 *
 * Executables based on this information may be used in software
 * for Commodore Amiga computers.  All other rights reserved.
 *
 * This information is provided "as is"; no warranties are made.
 * All use is at your own risk, and no liability or responsibility is assumed.
 */

#include "sysall.h"
#include "oscan.h"

#define HRULEY		(150L)
#define VRULEX		(300L)
#define VRULESTART	(2)			/* start VRULE at 200	*/

#define HASHHEIGHT	(20L)		/* size of hash marks	*/
#define HASHWIDTH	(20L)	

struct BitMap *
getHugeBitMap( numplanes )
int				numplanes;
{
	struct BitMap	*bmap;
	int				plane;

	if ( numplanes < 1 ) numplanes = 1;
	if ( numplanes > 4 ) numplanes = 4;

	bmap = (struct BitMap *)
		AllocMem( (LONG) sizeof ( struct BitMap ), (ULONG) MEMF_CLEAR );

	if ( bmap )
	{
		InitBitMap( bmap, (LONG) numplanes, HUGEWIDTH, HUGEHEIGHT );
		for ( plane = 0; plane < numplanes; ++plane )
		{
			if (!(bmap->Planes[ plane ] = AllocRaster( HUGEWIDTH, HUGEHEIGHT )))
			{
				printf(" cannot get raster: %d\n", plane );
				freeHugeBitMap( bmap );
				return ( NULL );
			}
		}
	}
	return ( bmap );
}

freeHugeBitMap( bmap )
struct BitMap *bmap;
{
	int		plane;

	if ( bmap )
	{
		plane = bmap->Depth;
		while ( plane-- )
		{
			if ( bmap->Planes[ plane ] )
			{
				FreeRaster( bmap->Planes[plane], HUGEWIDTH, HUGEHEIGHT );
			}
		}
		FreeMem( bmap, (LONG) sizeof ( struct BitMap ) );
	}
}

UBYTE	posbuff[ 20 ];

drawHugeBitMap( rp )
struct RastPort *rp;
{
	int		hunnert;
	int		pos;
	int		endpos;
	int		tlength;

	/* draw horizontal counters and hashmarks */
	SetAPen( rp, 1L );
	Move( rp, 0L, (LONG) HRULEY + HASHHEIGHT / 2 );
	Draw( rp, (LONG) HUGEWIDTH - 1, (LONG) HRULEY + HASHHEIGHT / 2 );

	for (hunnert = 0; (endpos = (hunnert+1) * 100) <= HUGEWIDTH; ++hunnert)
	{
		/* tall hashmark at X00	*/
		pos = hunnert * 100;
		SetAPen( rp, 3L );
		Move( rp, (LONG) pos, HRULEY );
		Draw( rp, (LONG) pos, HRULEY  + 2 * HASHHEIGHT);

		while (  (pos += 10) < endpos )
		{
			Move( rp, (LONG) pos, HRULEY );
			Draw( rp, (LONG) pos, HRULEY  + HASHHEIGHT);
		}

		sprintf( posbuff, "%d", endpos);
		tlength = TextLength( rp, posbuff, (LONG) strlen( posbuff ) );
		SetAPen( rp, 7L );
		Move( rp, (LONG) endpos - tlength - 1,
			HRULEY  + 2 * HASHHEIGHT);
		Text( rp, posbuff, (LONG) strlen( posbuff ) );
	}

	/* draw vertical counters */
	Move( rp, VRULEX + HASHWIDTH / 2, (LONG) VRULESTART * 100 );
	Draw( rp, VRULEX + HASHWIDTH / 2, (LONG) HUGEHEIGHT - 1 );

	for (hunnert = VRULESTART;
		(endpos = (hunnert + 1) * 100) <= HUGEHEIGHT; ++hunnert)
	{
		/* wide hashmark at X00	*/
		pos = hunnert * 100;
		Move( rp, VRULEX, (LONG) pos);
		Draw( rp,  VRULEX  + 2 * HASHWIDTH, (LONG) pos);

		while (  (pos += 10) < endpos )
		{
			Move( rp, VRULEX, (LONG) pos);
			Draw( rp,  VRULEX  + HASHWIDTH, (LONG) pos);
		}

		sprintf( posbuff, "%d", endpos);
		tlength = TextLength( rp, posbuff, (LONG) strlen( posbuff ) );
		Move( rp, VRULEX - tlength - 1, (LONG) endpos - 1);
		Text( rp, posbuff, (LONG) strlen( posbuff ) );
	}
}
