/* getargs.h -- command arguments	*/

struct Arg {
	char	arg_char;		/* the 'h' in "-h"			*/
	int		arg_type;		/* from defines below		*/
	void	*arg_var;		/* pointer to var for arg	*/
	char	*arg_descr;		/* description for Usage()	*/
};

#define SWITCHCHAR '-'		/* stole name from undocumented MS-DOS string	*/

#define ARG_TINT	0
#define	ARG_TBOOL	1		/* BOOLs must default to false					*/
#define ARG_TSTRING	2		/* string will be in argv, so copy if tricky	*/

#define ARG_EOK			(0)		/* getargs() worked out ok		*/
#define ARG_EBADINT		(-1)	/* int argument had bad format	*/
#define ARG_ENODATA		(-2)	/* needed further data, none there	*/
#define ARG_EUNKNOWN	(-3)	/* unknown argument				*/
#define ARG_EBADTYPE	(-4)	/* arg_type not valid			*/

#define NUMARGS(argarray) (sizeof (argarray)/sizeof (struct Arg))
