/* dview.h -- double-buffer views
 * Copyright (c) 1988, I and I Computing, and James Mackraz.
 *
 *
 * Executables based on this information may be used in software
 * for Commodore Amiga computers.  All other rights reserved.
 *
 * This information is provided "as is"; no warranties are made.
 * All use is at your own risk, and no liability or responsibility is assumed.
 */

struct DoubleView {
	int				dv_Current;			/* values either 0 or 1	*/
	struct RastPort	*dv_RastPorts[2];	/* draw into the Views	*/
	struct View		*dv_Views[2];
	int				dv_Width;
	int				dv_Height;
	int				dv_Signal;			/* video sync signal	*/
	long			dv_SigMask;			/* shifted video signal	*/
};

struct RastPort *selectDV();
struct RastPort *swapDV();
struct UCopList	*createUCop();

#define DV_CURRENT( dv )	( (dv)->dv_Current )
