/* buildt.c --  autorequest builder test program
 * Copyright (c) 1988, I and I Computing and Commodore-Amiga, Inc.
 *
 *
 * Executables based on this information may be used in software
 * for Commodore Amiga computers.  All other rights reserved.
 *
 * This information is provided "as is"; no warranties are made.
 * All use is at your own risk, and no liability or responsibility is assumed.
 */


/*
 * This is an old, ugly test program shell.  Sorry about that.
 * It's probably not too good an example to use.
 */

#include <exec/types.h>
#include <intuition/intuition.h>

#include "getargs.h"

struct  Window      *getNewWind();

struct  IntuitionBase   *IntuitionBase = NULL;
struct  GfxBase         *GfxBase = NULL;

ULONG   flg =   WINDOWCLOSE | NOCAREREFRESH | WINDOWDRAG
                | WINDOWDEPTH | SIMPLE_REFRESH;

ULONG   iflg =  CLOSEWINDOW | MOUSEBUTTONS;

BOOL	short_bool =	FALSE;
BOOL	long_bool =		TRUE;
BOOL	arg_bool =		FALSE;

struct Arg myargs[] = {
	{'s', ARG_TBOOL, &short_bool, "short strings"},
	{'l', ARG_TBOOL, &long_bool, "medium-long strings"},
	{'a', ARG_TBOOL, &arg_bool, "command-line arguments"},
};

/* some short strings */
char   *SReqStrings[] = {
    "P",
    "Q",
    "R",
    NULL
};

/* some longer strings */
char   *AReqStrings[] = {
    "Please insert your favorite Tie",
    "into this here disk drive",
    "or you'll never see your mother again.",
    NULL
};

char   *retrytext;
char   *canceltext;
char	**reqstrings;

main(argc, argv)
char	**argv;
{
    struct  IntuiMessage    *msg;
    struct Window   *window = NULL;
    WORD    exitval = 0;

    ULONG result;
	int		argb;

    /* hold data from *msg  */
    ULONG   class;
    USHORT  code;

    if ((IntuitionBase = 
        (struct IntuitionBase *) OpenLibrary("intuition.library", 0L)
        ) == NULL)
    {
        printf("NO INTUITION LIBRARY\n");
        exitval = 1;
        goto EXITING;
    }

    if ((GfxBase = 
        (struct GfxBase *) OpenLibrary("graphics.library", 0L)
        ) == NULL)
    {
        printf("NO GRAPHICS LIBRARY\n");
        exitval = 2;
        goto EXITING;
    }

	/* command-line arguments	*/
    if ( (argb = getargs( argv, myargs, NUMARGS( myargs ), NULL)) < 0 )
		goto EXITING;

	argv += argb;

	if ( short_bool )
	{
		reqstrings =  SReqStrings;
		retrytext =    "L";
		canceltext =   "R";
	}
	else if ( arg_bool )
	{
		reqstrings = argv;
		retrytext =    "Left";
		canceltext =   "Right";
	}
	else
	{
		reqstrings =  AReqStrings;
		retrytext =    "This tie?";
		canceltext =   "Keep her";
	}

    /* init libraries and window    */
    window = getNewWind(20, 20, 500, 50, flg, iflg);
    if (window == NULL)
    {
        printf("test: SysInit failed.\n");
        exitval = 1;
        goto EXITING;
    }

    /* OTHER INIT CODE HERE */

    printf("test program ok\n");

    FOREVER
    {
        if ((msg = (struct IntuiMessage *)GetMsg(window->UserPort)) == NULL)
        {
            Wait( 1L << window->UserPort->mp_SigBit );
            continue;
        }

        /* Stash message contents and reply,
         * important when message triggers some
         * lengthy processing
         */

        class   = msg->Class;
        code    = msg->Code;
        ReplyMsg( msg );

        switch (class)
        {
        case MOUSEBUTTONS:
            switch( code )
            {
            case SELECTDOWN:
                printf("MOUSE SELECTDOWN\n");
                printf("calling buildAutoRequest:\n");

				/* test build function */
                result = buildAutoRequest( window, reqstrings,
                        retrytext, canceltext, 0L, 0L);
                printf("result %x\n", result);

                break;
            }
#if LOOPMODE
            break;
#else
            goto EXITING;
#endif
        case CLOSEWINDOW:
            goto EXITING;
        default:
			break;
        }
    }

EXITING:
    if (window) CloseWindow(window);
    if (GfxBase) CloseLibrary(GfxBase);
    if (IntuitionBase) CloseLibrary(IntuitionBase);
    exit (exitval);
}


struct  Window * getNewWind(left, top, width, height, flg, iflg)
SHORT   left, top, width, height;
ULONG   flg, iflg;
{
    struct  Window  *OpenWindow();
    struct  NewWindow   nw;

    nw.LeftEdge =   (SHORT) left;
    nw.TopEdge  =   (SHORT) top;
    nw.Width    =   (SHORT) width;
    nw.Height   =   (SHORT) height;
    nw.DetailPen    =   (UBYTE) -1;
    nw.BlockPen =   (UBYTE) -1;
    nw.IDCMPFlags   =   (ULONG) iflg;

    nw.Flags    =   (ULONG) flg;

    nw.FirstGadget  =   (struct Gadget *)   NULL;
    nw.CheckMark    =   (struct Image *)    NULL;
    nw.Title    =   (UBYTE *)   " Click in Window for AutoRequest";
    nw.Screen   =   (struct Screen *)   NULL;
    nw.BitMap   =   (struct BitMap *)   NULL;
    nw.MinWidth =   (SHORT) 50;
    nw.MinHeight=   (SHORT) 30;
	nw.MaxWidth = nw.MinWidth;
	nw.MaxHeight = nw.MinHeight;
	nw.Type = WBENCHSCREEN;

	return ( (struct Window *) OpenWindow( &nw ) );
}

