/* buildreq.c -- build autorequester
 * (thanks to Neil Katin for an earlier version)
 * Copyright (c) 1988, I and I Computing and Commodore-Amiga, Inc.
 *
 * Executables based on this information may be used in software
 * for Commodore Amiga computers.  All other rights reserved.
 *
 * This information is provided "as is"; no warranties are made.
 * All use is at your own risk, and no liability or responsibility is assumed.
 */

#include <exec/types.h>
#include <exec/memory.h>
#include <intuition/intuition.h>

#define MAX(a,b)  (( (a) > (b) )? (a): (b))
#define MIN(a,b)  (( (a) < (b) )? (a): (b))

#define TEXTO	(12)

/* returns 0 if failure to get needed memory, else
 * returns value from AutoRequest
 */
buildAutoRequest( window, textArray, pText, nText, pflags, nflags)
struct Window	*window;		/* we require this parameter	*/
UBYTE		**textArray;
UBYTE		*pText;
UBYTE		*nText;
ULONG		pflags;
ULONG		nflags;
{
    int		height;		/* dimensions for requester	*/
    int		width;
    int		wheight;	/* dimensions for window	*/
    int		wwidth;
    int		sizeArray;	/* bytes in all IntuiText structs	*/
    int		result;
    UBYTE	**sa;
    struct IntuiText	*itArray, *ita, *itPos,*itNeg;
    struct RastPort	*rp;
    struct Screen	*screen;
    int		fontheight;

    if ( (! *textArray) || (! window) ) return (0);

    screen = window->WScreen;
    rp = &screen->RastPort;
    fontheight = rp->TxHeight;

    printf("bAR: fontheight: %d\n", fontheight);

    /*** compute width and height (of Requester, for now) ***/

    /* width for gadgets and some spacing	*/
    width = TextLength( rp, pText, (ULONG) strlen( pText ))
		+ TextLength( rp, nText, (ULONG) strlen( nText )) + 70;

    /* account for gadgets, and miscellaneous spacing	*/
    height = fontheight + 20;

    for ( sa = textArray; *sa; sa++ )
    {
		height += fontheight + 2;
		width = MAX( width, TextLength( rp, *sa, (ULONG) strlen( *sa )));
    }

    /*** initialize IntuiText structures	***/

    /* count 2 IntuiText structures for pText and nText	*/
    sizeArray = ((sa - textArray) + 2) * sizeof( struct IntuiText );

    itArray = (struct IntuiText *) AllocMem( (LONG) sizeArray, (LONG)MEMF_CLEAR);

    if ( ! itArray ) return ( 0 );

    itArray->TopEdge = 4;	/* spacing from top of Requester	*/
    for ( ita = itArray, sa = textArray; *sa; sa++, ita++ )
    {
		initIntuiText( ita, *sa, &ita[ 1 ], fontheight );
    }
    /* now ita points to first of two text structures for retry/cancel	*/
    ita[ -1 ].NextText = NULL;		/* terminate list	*/

    itPos = ita++;
    initIntuiText( itPos, pText, NULL, fontheight );

    itNeg = ita;
    initIntuiText( itNeg, nText, NULL, fontheight );

    itPos->TopEdge = itNeg->TopEdge = AUTOTOPEDGE;
    itPos->LeftEdge = itNeg->LeftEdge = AUTOLEFTEDGE;

    /*** do it ***/

    /* account for unknown width of sizing gadget :-( */
    wwidth = MIN( width+screen->WBorLeft+screen->WBorRight+(2*TEXTO)+20,
	    screen->Width);
    wheight = MIN( height + screen->BarHeight +
	screen->WBorTop + screen->WBorBottom, screen->Height);

    printf("width, height %d/%d\n", width, height);
    printf("window w/h: %d/%d\n", wwidth, wheight);

    result = (int) AutoRequest( window, itArray, itPos, itNeg,
		pflags, nflags, (LONG) wwidth, (LONG) wheight);

    FreeMem( itArray, (LONG) sizeArray );

    return ( result );
}


/* assumes structures are cleared (0) already */
initIntuiText( it, text, itNext, fontheight )
struct IntuiText *it;
UBYTE *text;
struct IntuiText *itNext;
int	fontheight;
{
    it->FrontPen = 0;
    it->BackPen = 1;
    it->DrawMode = JAM1;
    it->IText = text;
    it->LeftEdge = TEXTO;

    if( itNext ) {
		it->NextText = itNext;
		itNext->TopEdge = it->TopEdge + fontheight +2;
    }
}
