;
; Copyright (c) 1988 Commodore-Amiga, Inc.
;
; Executables based on this information may be used in software
; for Commodore Amiga computers.  All other rights reserved.
;
; This information is provided "as is"; no warranties are made.
; All use is at your own risk, and no liability or responsibility is assumed.
;

		CODE

		XDEF	Sine,Cosine

;=============================================================================
;   res = Sine( multiplier, theta )
;    D0		    D0	      D1
;
; A fast fixed point routine to return a value multiplied by sin( theta )
;============================================================================
Sine		move.w	d2,-(sp)
		move.w	d0,-(sp)
		bpl.s	5$
		neg.w	d0
5$		ext.l	d1
		divu.w	#90,d1			; get angle in range 0-89
		move.w	d1,d2			; lower word = quadrant 0-3
		swap	d1			; get actual angle
		btst.b	#0,d2			; if quadrant 1 or 3...
		beq.s	10$			; ...reverse index value
		neg.w	d1
		addi.w	#90,d1
10$		asl.w	#1,d1			; compute index into table
		mulu.w	SinCosTable(pc,d1.w),d0	; multiply by (sine*65536)
		swap	d0			; divide by 65536
		bpl.s	15$			; if msw >= $8000 round up
		addq.w	#1,d0
15$		btst.b	#1,d2			; if quadrant > 1 ...
		beq.s	20$			; ...negate the result
		neg.w	d0
20$		ext.l	d0			; make result a longword
		move.w	(sp)+,d1		was original negative
		bpl.s	30$			no
		neg.l	d0			yes so negate result
30$		move.w	(sp)+,d2
		rts


;=============================================================================
;   res = Cosine( multiplier, theta )
;    D0		    D0	      D1
;
; Fast fixed point routine to return a value multiplied by cos( theta )
;============================================================================
Cosine		move.w	d2,-(sp)
		move.w	d0,-(sp)		save multiplier
		bpl.s	5$			make it positive
		neg.w	d0
5$		ext.l	d1
		divu.w	#90,d1			; get angle in range 0-89
		moveq.l	#3,d2			; D2 = quadrant 0-3
		and.w	d1,d2
		swap	d1			; get actual angle
		btst.b	#0,d2			; if quadrant 0 or 2...
		bne.s	10$			; ...reverse the index
		neg.w	d1
		addi.w	#90,d1
10$		asl.w	#1,d1			; compute index into table
		mulu.w	SinCosTable(pc,d1.w),d0	; multiply by (cosine*65536)
		swap	d0			; divide by 65536
		bpl.s	15$			; if msw >= $8000 round up
		addq.w	#1,d0
15$		cmpi.w	#1,d2			; if quadrant=1 or ...
		beq.s	20$			; ...quadrant=2 ...
		cmpi.w	#2,d2			; ...negate result
		bne.s	30$
20$		neg.w	d0
30$		ext.l	d0			; make result a longword
		move.w	(sp)+,d1		was original negative ?
		bpl.s	40$			no
		neg.l	d0			yes, negate result
40$		move.w	(sp)+,d2
		rts

;============================================================================
; table of sines or cosines for 0-89 degrees expressed as fractions of 65536
;============================================================================
SinCosTable	DC.W	00000,01144,02287,03430,04571,05712
		DC.W	06850,07987,09121,10252,11380,12505
		DC.W	13625,14742,15854,16962,18064,19161
		DC.W	20251,21336,22414,23486,24550,25607
		DC.W	26655,27696,28729,29752,30767,31772
		DC.W	32768,33753,34728,35693,36647,37589
		DC.W	38521,39440,40347,41243,42125,42995
		DC.W	43851,44695,45524,46340,47142,47929
		DC.W	48702,49460,50203,50930,51642,52339
		DC.W	53019,53683,54331,54962,55577,56174
		DC.W	56755,57318,57864,58392,58902,59395
		DC.W	59869,60325,60763,61182,61583,61965
		DC.W	62327,62671,62996,63302,63588,63855
		DC.W	64103,64331,64539,64728,64897,65047
		DC.W	65176,65286,65375,65445,65495,65525
		DC.W	65535

		END
