;
; Copyright (c) 1988 Commodore-Amiga, Inc.
;
; Executables based on this information may be used in software
; for Commodore Amiga computers.  All other rights reserved.
;
; This information is provided "as is"; no warranties are made.
; All use is at your own risk, and no liability or responsibility is assumed.
;

		XREF	_LVOOpenLibrary,_LVOCloseLibrary

;==============================================================================
; Success = OpenLibs( libtable )
;   d0			 a0
;
; Opens all libraries referenced in the library table.  Table format is:-
;
;	version,name,offset		(all are signed words)
;
; Version is the version number required for this library.
; Name is the offset from libtable to the required library name.
; Offset is the offset (from global pointer a5) of where to store lib ptr.
; List is terminated by a version number of -1
;==============================================================================
OpenLibs	movem.l	a2-a3/a6,-(sp)
		movea.l	SysLib(a5),a6		using exec library
		movea.l	a0,a2			save working libtable ptr
		movea.l	a0,a3			a3 used to calculate name addr

10$		moveq.l	#0,d0			get the version
		move.w	(a2)+,d0
		bmi.s	LibsOpened		return TRUE
		move.w	(a2)+,d1		get offset to name
		lea.l	0(a3,d1.w),a1		addr of name in a1
		jsr	_LVOOpenLibrary(a6)	open the lib
		move.w	(a2)+,d1		offset to store at
		move.l	d0,0(a5,d1.w)		save in global table
		bne.s	10$			OK, go for the next
LibsOpened	movem.l	(sp)+,a2-a3/a6		could return 0 if failed above
		rts		

;==============================================================================
; CloseLibs( libtable )
;		a0
;
; Closes all libraries opened by OpenLibs() providing the pointer to that
; library (as stored in global table) is non zero, (the open succeeded).
;==============================================================================
CloseLibs	movem.l	a2/a6,-(sp)
		movea.l	SysLib(a5),a6		using exec library
		movea.l	a0,a2			save libtable pointer

10$		tst.w	(a2)+			end of list ?
		bmi.s	LibsClosed		yes, quit now
		move.l	(a2)+,d0		offset to lower word
		move.l	0(a5,d0.w),d0		get lib pointer
		beq.s	LibsClosed		that's it, this one failed
		movea.l	d0,a1
		jsr	_LVOCloseLibrary(a6)	close this library
		bra.s	10$			and go for the next
LibsClosed	movem.l	(sp)+,a2/a6
		rts

;==============================================================================
; An example list of libraries that would be sent to the OpenLibraries routine.
; IntLib, GfxLib and DosLib would all be members defined in the global struct.
;==============================================================================
Libraries	DC.W	33,IntName-Libraries,IntLib
		DC.W	33,GfxName-Libraries,GfxLib
		DC.W	33,DosName-Libraries,DosLib
		DC.W	-1
IntName		DC.B	'intuition.library',0
		CNOP	0,2
GfxName		DC.B	'graphics.library',0
		CNOP	0,2
DosName		DC.B	'dos.library',0
		CNOP	0,2

		END
