;
; Copyright (c) 1988 Commodore-Amiga, Inc.
;
; Executables based on this information may be used in software
; for Commodore Amiga computers.  All other rights reserved.
;
; This information is provided "as is"; no warranties are made.
; All use is at your own risk, and no liability or responsibility is assumed.
;

		XREF	_LVOAllocMem,_LVOFreeMem

;==============================================================================
; Success = AllocMemory( memtable )
;   d0			    a0
;
; Allocates all memory in the given table and returns false if it failed.
; memory table is formatted as follows:-
;
; size.l,type.w,offset.w
; ......
; -1
;
; Size is the required size for this chunk of memory.
; Type is the memory type required, it is always ored with MEMF_CLEAR
; Offset is the offset to store at (off the a5 global pointer)
;==============================================================================
AllocMemory	movem.l	a2/a6,-(sp)
		movea.l	SysLib(a5),a6		using exec library
		movea.l	a0,a2			stash memtable address

10$		move.l	(a2)+,d0		get size
		bmi.s	MemAlloced		last entry, return true
		moveq.l	#0,d1
		move.w	(a2)+,d1		get type
		bset.l	#MEMB_CLEAR,d1		clear it too
		jsr	_LVOAllocMem(a6)	allocate it
		move.w	(a2)+,d1		get store offset
		move.l	d0,0(a5,d1.w)		save it
		bne.s	10$			OK, memory fetched
MemAlloced	movem.l	(sp)+,a2/a6		could return 0 if it failed
		rts

;==============================================================================
; FreeMemory( memtable )
;		 a0
;
; Frees all the memory that was allocated by AllocMemory up to the first zero
; pointer (or allocation that failed).  Use same table as used for AllocMemory.
;==============================================================================
FreeMemory	movem.l	a2/a6,-(sp)
		movea.l	SysLib(a5),a6		using exec library
		movea.l	a0,a2			stash table pointer

10$		move.l	(a2)+,d0		end of list
		bmi.s	MemFreed		yep, exit now
		move.l	(a2)+,d1		offset to lower word
		move.l	0(a5,d1.w),d1		get pointer
		beq.s	MemFreed		quit! alloc failed on this one
		movea.l	d1,a1
		jsr	_LVOFreeMem(a6)
		bra.s	10$
MemFreed	movem.l	(sp)+,a2/a6
		rts

		END
