
;
; Copyright (c) 1988 Commodore-Amiga, Inc.
;
; Executables based on this information may be used in software
; for Commodore Amiga computers.  All other rights reserved.
;
; This information is provided "as is"; no warranties are made.
; All use is at your own risk, and no liability or responsibility is assumed.
;

;=============================================================================
; NAME
;    bin2asc[nn] - converts binary to a signed decimal string
;
; SYSNOPSIS
;    string=bin2asc[nn]( value,buffer )
;      D0		   D0    A0
;
; FUNCTION
;    converts the given value to null terminated string of ascii digits
;
; INPUTS
;    value - the value to be converted
;    [nn]denotes the size of the operator being worked on, this can be
;    any of 8,16 or 32
;
;    buffer - where the string should go
;
; RESULT
;    string - pointer to the null terminated decimal string
;
; BUGS
;
; SEE ALSO
;
;============================================================================

bin2asc16	EXT.L	D0			make word into a longword
bin2asc32	TST.L	D0			is it negative ?
		BPL.S	bin2asc			nope, call main routine
		NEG.L	D0			make positive
		MOVE.B	#'-',(A0)+		output a minus sign

;=============================================================================
; NAME
;    bin2asc - converts unsigned binary in D0 to ascii digits in a buffer
;
; SYSNOPSIS
;    number = bin2asc( value,buffer )
;      D0		 D0    A0
;
; FUNCTION
;     converts the unsigned binary value in D0 to a null terminated string
;     of ascii digits beginning at the buffer position given
;
; INPUTS
;    value - 32 bit unsigned value
;
;    buffer - pointer to the buffer where the digits should be put
;
; RESULT
;    number is generated and original pointer is returned in D0
;
; BUGS
;
; SEE ALSO
;
;============================================================================

bin2asc		MOVEM.L	D2-D3/A2-A3,-(SP)
		MOVEA.L	A0,A3			save buffer pointer
		LEA.L	PowersOfTen(PC),A2	powers of ten table
		MOVEQ.L	#0,D1			leading zero flag
		MOVE.L	(A2)+,D2		fetch first power of ten

10$		MOVEQ.L	#-1,D3			current digit value
20$		ADDQ.B	#1,D3			update this digit
		SUB.L	D2,D0			subtract current pwr of 10
		BPL.S	20$			go for another
		ADD.L	D2,D0			fix, we went too far
		TST.B	D3			is this a zero ?
		BNE.S	30$			no, skip leading zero test
		TST.W	D1			have we put in any digits yet?
		BEQ.S	40$			no, so scrap this one
30$		MOVEQ.L	#1,D1			stop suppressing zeros now
		ADDI.B	#'0',D3			make an ascii digit
		MOVE.B	D3,(A0)+		store it
40$		MOVE.L	(A2)+,D2		get next power of 10
		BNE.S	10$			do the next bit

		TST.W	D1			did we put any digits in
		BNE.S	50$			yes
		MOVE.B	#'0',(A0)+		no, put zero as the result
50$		CLR.B	(A0)			terminate the string
		MOVE.L	A3,D0			retrieve pointer to buffer
		MOVEM.L	(SP)+,D2-D3/A2-A3
		RTS

PowersOfTen	DC.L	1000000000,100000000,10000000,1000000
		DC.L	100000,10000,1000,100,10,1,0

;=============================================================================
; NAME
;    bin2hex[nn] - converts a binary longword to a string of hex digits
;
; SYSNOPSIS
;    string = bin2hex[nn]( value,buffer )
;      D0		     D0    A0
;
; FUNCTION
;    converts the value to a null terminated string of hex digits
;
; INPUTS
;    value - the value to be converted
;    [nn]denotes the size of the operator being worked on, this can be
;    any of 16 or 32
;
;    buffer - where the result will go
;
; RESULT
;    string - pointer to the string of hex digits (null terminated)
;
; BUGS
;
; SEE ALSO
;
;============================================================================

bin2hex32	MOVEQ.L	#7,D1			generate a longword
		BRA.S	dohex
bin2hex16	MOVEQ.L	#3,D1			generate a word

dohex		MOVE.L	D2,-(SP)
		MOVE.L	D0,D2			save the value
		MOVEA.L	A0,A1			save buffer address for later
		CLR.B	1(A0,D1.W)		terminate the string
10$		MOVE.B	D2,D0			get next nybble
		ANDI.B	#$0F,D0
		ADDI.B	#'0',D0			make into ascii
		CMPI.B	#'9',D0
		BLE.S	20$			no adjustment for letters
		ADDI.B	#('A'-'9')-1,D0		add offset for letters
20$		MOVE.B	D0,0(A0,D1.W)		store this digit
		LSR.L	#4,D2			move next nybble into place
		DBRA	D1,10$

		MOVE.L	A1,D0			return address of buffer
		MOVE.L	(SP)+,D2
		RTS


