******* Startup/Strings **********************************************
*
*   Copyright 1986, Robert R. Burns
*
*   Executables based on this information may be used in software
*   for Commodore Amiga computers.
*
**********************************************************************


	SECTION	startup,CODE

	XDEF	StrLen
	XDEF	StrCopy
	XDEF	StrCmp
	XDEF	StrNCCmp
	XDEF	StrToNum
	XDEF	StrB2C

	XDEF	_StrLen
	XDEF	_StrCopy
	XDEF	_StrCmp
	XDEF	_StrNCCmp
	XDEF	_StrToNum
	XDEF	_StrB2C

******* StrLen *******************************************************
_StrLen:
		move.l	4(a7),a0

StrLen:
		moveq	#-1,d0
1$:
		addq.l	#1,d0
		tst.b	(a0)+
		bne.s	1$
		rts

******* StrCopy ******************************************************
_StrCopy:
		movem.l	4(a7),a0/a1

StrCopy:
		move.b	(a0)+,(a1)+
		bne.s	StrCopy

		rts

******* StrCmp *******************************************************
_StrCmp:
		movem.l	4(a7),a0/a1

StrCmp:
		move.b	(a1)+,d0
		beq.s	1$		; second string is done
		cmp.b	(a0)+,d0
		beq.s	StrCmp		; still equal
		bgt.s	2$		; second string is greater
3$:
		moveq	#1,d0		; first string is greater
		rts
1$:
		tst.b	(a0)		; is first string done?
		bne.s	3$		; first string is greater
		moveq	#0,d0		; strings are equal
		rts
2$:
		moveq	#-1,d0		; second string is greater
		rts
******* StrNCCmp *****************************************************
_StrNCCmp:
		movem.l	4(a7),a0/a1

StrNCCmp:
		movem.l	d2/d3,-(a7)
		clr	d0
snccStillEqual:
		move.b	(a1)+,d0
		beq.s	1$		; second string is done
		bsr.s	deCase
		move.b	d0,d1		; save decased byte
		move.b	(a0)+,d0
		bsr.s	deCase
		cmp.b	d0,d1
		beq.s	snccStillEqual	; still equal
		bgt.s	2$		; second string is greater
3$:
		moveq	#1,d0		; first string is greater
		bra.s	snccRts
1$:
		tst.b	(a0)		; is first string done?
		bne.s	3$		; first string is greater
		moveq	#0,d0		; strings are equal
		bra.s	snccRts
2$:
		moveq	#-1,d0		; second string is greater
snccRts:
		movem.l	(a7)+,d2/d3
		rts

deCase:
		move.w	d0,d2
		and.w	#7,d2
		move.w	d0,d3
		lsr.w	#3,d3
		btst	d2,caseList(pc,d3.w)
		beq.s	noLC
		and.b	#$df,d0		; convert to upper case
noLC:
		rts

caseList:	dc.b	0,0,0,0,0,0,0,0
		dc.b	%11111110,%11111111,%11111111,%00000111
		dc.b	%11111110,%11111111,%11111111,%00000111
		dc.b	0,0,0,0,0,0,0,0
		dc.b	%11111111,%11111111,%11111110,%11111110
		dc.b	%11111111,%11111111,%11111110,%11111110

******* StrToNum *****************************************************
_StrToNum:
		move.l	4(a7),a0

StrToNum:
		movem.l	d2/d3,-(a7)
		moveq	#0,d0		; start with zero
		moveq	#0,d1		; clear upper bytes
		moveq	#10,d3		; assume base of 10

		cmpi.b	#'-',(a0)	; check for minus sign
		bne.s	initialStr
		moveq	#31,d1
		bset	d1,d3		; show minus sign
		addq.l	#1,a0		; skip minus sign

initialStr:

		move.b	(a0)+,d1	; get characters from start
		cmpi.b	#'0',d1
		beq.s	initialStr	; chuck initial zeros
		cmpi.b	#'x',d1		; check for hex forms
		beq.s	initialHex	;
		cmpi.b	#'$',d1		;
		beq.s	initialHex	;
		tst.b	d1
		bra.s	bodyConvert		

bodyStr:
		move.b	(a0)+,d1	; get next character
bodyConvert:
		beq.s	bodyDone
		move.w	d0,d2		; save lsw of collection
		swap	d0
		mulu	d3,d0		; multiply up msw of collection
		swap	d0
		clr.w	d0		; throw away any overflow (!)
		mulu	d3,d2		; multiply up ls2 of collection
		add.l	d2,d0

		cmpi.b	#'0',d1
		blt.s	badChar
		cmpi.b	#'9',d1
		bgt.s	perhapsHex
		subi.b	#'0',d1
		add.l	d1,d0
		bra.s	bodyStr

perhapsHex:
		cmp.w	#16,d3
		bne.s	badChar
		cmpi.b	#'A',d1
		blt.s	badChar
		cmpi.b	#'F',d1
		bgt.s	perhapsLCHex
		subi.b	#'A'-10,d1
		add.l	d1,d0
		bra.s	bodyStr

perhapsLCHex:
		cmpi.b	#'a',d1
		blt.s	badChar
		cmpi.b	#'f',d1
		bgt.s	badChar
		subi.b	#'a'-10,d1
		add.l	d1,d0
		bra.s	bodyStr

initialHex:
		move.w	#16,d3		; show base of 16, preserving minus
		bra.s	bodyStr

bodyDone:
		tst.l	d3
		bpl.s	returnNum
		neg.l	d0
returnNum:
		movem.l	(a7)+,d2/d3
		rts

badChar:
		move.l	#$80000000,d0
		bra.s	returnNum

******* StrB2C *******************************************************
_StrB2C:
		movem.l	4(a7),a0/a1

StrB2C:
		clr.w	d0
		move.b	(a0)+,d0
		bra.s	2$
1$:
		move.b	(a0)+,(a1)+
2$:
		dbf	d0,1$
		clr.b	(a1)
		rts

	END
