/*
	Code to test AppMenuItem feature of Workbench.
*/

#include <intuition/intuition.h>
#include <workbench/startup.h>
#include "workbench/workbench.h"

#define INTUITIONNAME	"intuition.library"
#define WORKBENCHNAME	"workbench.library"

struct IntuitionBase *IntuitionBase = NULL;
struct WorkbenchBase *WorkbenchBase = NULL;

struct NewWindow nw = {
	0, 0,		/* leftedge, topedge */
	160,50,		/* width, height */
	-1, -1,		/* DetailPen, BlockPen */
	CLOSEWINDOW,		/* IDCMP flags */
	WINDOWCLOSE|WINDOWDRAG,		/* flags */
	NULL,		/* FirstGadget */
	NULL,		/* Image */
	"AppMenuItem",	/* Title */
	NULL,		/* Screen */
	NULL,		/* BitMap */
	0, 0,		/* MinWidth, MinHeight */
	0, 0,		/* MaxWidth, MaxHeight */
	WBENCHSCREEN	/* type */
};

main(argc, argv)
int argc;
char **argv;
{
	void *OpenLibrary();
	struct MsgPort *CreatePort();
	struct Window *OpenWindow();
	struct IntuiMessage *GetMsg();
	struct AppMenuItem *AddAppMenuItem();

	struct MsgPort *msgport = NULL;
	struct Window *win = NULL;
	struct AppMenuItem *ami1 = NULL, *ami2 = NULL;
	struct IntuiMessage *imsg;
	struct AppMessage *amsg;
	struct WBArg *argptr;
	ULONG id = 1, userdata = 0;
	BOOL done = FALSE;
	int i;

	printf("ami: enter\n");
	if (!(IntuitionBase = OpenLibrary(INTUITIONNAME, 0))) {
		printf("ami: could not open intuition\n");
		goto err;
	}
	if (!(WorkbenchBase = OpenLibrary(WORKBENCHNAME, 36))) {
		printf("ami: could not open workbench\n");
		goto err;
	}
	if (!(msgport = CreatePort("appmenuitem", 0))) {
		printf("ami: could not createport\n");
		goto err;
	}
	if (!(win = OpenWindow(&nw))) {
		printf("ami: could not openwindow\n");
		goto err;
	}
	printf("ami: calling AddAppMenuItem for ami1...");
	if (!(ami1 = AddAppMenuItem(id, userdata, "appmenuitem1", msgport))) {
		printf("ami: could not addappmenuitem\n");
		goto err;
	}
	printf("ami: calling AddAppMenuItem for ami2...");
	if (!(ami2 = AddAppMenuItem(85, 55, "appmenuitem2", msgport))) {
		printf("ami: could not addappmenuitem\n");
		goto err;
	}
	printf("ami: ok, ami2 = %lx, going to sleep\n", ami2);
	do {
		Wait((1 << win->UserPort->mp_SigBit) |
			(1 << msgport->mp_SigBit));
		while (imsg = GetMsg(win->UserPort)) {
			if (imsg->Class == CLOSEWINDOW) {
				done = TRUE;
			}
		};
		while (amsg = GetMsg(msgport)) {
			printf("ami: appmsg=%lx, Type=%ld, ID=%ld, UserData=%ld, NumArgs=%ld\n", amsg, amsg->am_Type, amsg->am_ID, amsg->am_UserData, amsg->am_NumArgs);
			argptr = amsg->am_ArgList;
			for (i=0; i<amsg->am_NumArgs; i++) {
				printf("\targ(%ld): Name='%s', Lock=%lx\n",
				i, argptr->wa_Name, argptr->wa_Lock);
				argptr++;
			}
			ReplyMsg(amsg);
		};
	} while (!done);

	if (ami1) {
		printf("ami: calling RemoveAppMenuItem for ami1\n");
		RemoveAppMenuItem(ami1);
	}

	if (ami2) {
		printf("ami: calling RemoveAppMenuItem for ami2\n");
		RemoveAppMenuItem(ami2);
	}

err:
	if (win) {
		CloseWindow(win);
	}
	if (msgport) {
		DeletePort(msgport);
	}
	if (WorkbenchBase) {
		CloseLibrary(WorkbenchBase);
	}
	if (IntuitionBase) {
		CloseLibrary(IntuitionBase);
	}
	printf("ami: exit\n");
}
