/*
	Code to test AppIcon feature of Workbench.
*/

#include <intuition/intuition.h>
#include <exec/memory.h>
#include <workbench/startup.h>
#include "workbench/workbench.h"

#include "appicon.image"

#define INTUITIONNAME	"intuition.library"
#define WORKBENCHNAME	"workbench.library"
#define ICONNAME	"icon.library"

struct IntuitionBase *IntuitionBase = NULL;
struct WorkbenchBase *WorkbenchBase = NULL;
struct IconBase *IconBase = NULL;

struct NewWindow nw = {
	0, 0,		/* leftedge, topedge */
	160,50,		/* width, height */
	-1, -1,		/* DetailPen, BlockPen */
	CLOSEWINDOW,		/* IDCMP flags */
	WINDOWCLOSE|WINDOWDRAG,		/* flags */
	NULL,		/* FirstGadget */
	NULL,		/* Image */
	"AppIcon",	/* Title */
	NULL,		/* Screen */
	NULL,		/* BitMap */
	0, 0,		/* MinWidth, MinHeight */
	0, 0,		/* MaxWidth, MaxHeight */
	WBENCHSCREEN	/* type */
};

main(argc, argv)
int argc;
char **argv;
{
	void *OpenLibrary();
	struct MsgPort *CreatePort();
	struct Window *OpenWindow();
	struct IntuiMessage *GetMsg();
	struct AppIcon *AddAppIcon();
	struct DiskObject *GetDiskObject();

	struct MsgPort *msgport = NULL;
	struct Window *win = NULL;
	struct AppIcon *ai = NULL;
	struct IntuiMessage *imsg;
	struct AppMessage *amsg;
	struct WBArg *argptr;
	struct DiskObject *dobj;
	ULONG id = 1, userdata = 0;
	BOOL done = FALSE;
	int i, imagememsize = 0;

	printf("ai: enter\n");
	if (!(IntuitionBase = OpenLibrary(INTUITIONNAME, 0))) {
		printf("ai: could not open intuition\n");
		goto err;
	}
	if (!(WorkbenchBase = OpenLibrary(WORKBENCHNAME, 36))) {
		printf("ai: could not open workbench\n");
		goto err;
	}
	if (!(IconBase = OpenLibrary(ICONNAME, 36))) {
		printf("ai: could not open icon\n");
		goto err;
	}
	if (!(msgport = CreatePort("appicon", 0))) {
		printf("ai: could not createport\n");
		goto err;
	}
	if (!(win = OpenWindow(&nw))) {
		printf("ai: could not openwindow\n");
		goto err;
	}
	if (!(dobj = GetDiskObject(NULL))) {
		printf("ai: could not getdiskobject(NULL)\n");
		goto err;
	}
	dobj->do_Gadget.Width = image1.Width;
	dobj->do_Gadget.Height = image1.Height;
	dobj->do_Gadget.GadgetRender = &image1;
	imagememsize = (image1.Width * image1.Height * image1.Depth) / 8;
	if (!(image1.ImageData = (USHORT *)AllocMem(imagememsize, MEMF_CHIP))) {
		printf("ai: could not get chip mem for image\n");
		goto err;
	}
	CopyMem(imageData1, image1.ImageData, imagememsize);
	printf("ai: calling AddAppIcon...");
	if (!(ai = AddAppIcon(id, userdata, "AppIcon", msgport, NULL, dobj))) {
		printf("ai: could not addappicon\n");
		goto err;
	}
	printf("ai: ok, ai = %lx, going to sleep\n", ai);
	do {
		Wait((1 << win->UserPort->mp_SigBit) |
			(1 << msgport->mp_SigBit));
		while (imsg = GetMsg(win->UserPort)) {
			if (imsg->Class == CLOSEWINDOW) {
				done = TRUE;
			}
		};
		while (amsg = GetMsg(msgport)) {
			printf("ai: appmsg=%lx, Type=%ld, ID=%ld, UserData=%ld, NumArgs=%ld\n", amsg, amsg->am_Type, amsg->am_ID, amsg->am_UserData, amsg->am_NumArgs);
			argptr = amsg->am_ArgList;
			for (i=0; i<amsg->am_NumArgs; i++) {
				printf("\targ(%ld): Name='%s', Lock=%lx\n",
					i, argptr->wa_Name, argptr->wa_Lock);
				argptr++;
			}
			ReplyMsg(amsg);
		};
	} while (!done);

	if (ai) {
		printf("ai: calling RemoveAppIcon\n");
		RemoveAppIcon(ai);
	}

err:
	if (win) {
		CloseWindow(win);
	}
	if (msgport) {
		DeletePort(msgport);
	}
	if (dobj) {
		if (imagememsize) {
			FreeMem(image1.ImageData, imagememsize);
		}
		FreeDiskObject(dobj);
	}
	if (IconBase) {
		CloseLibrary(IconBase);
	}
	if (WorkbenchBase) {
		CloseLibrary(WorkbenchBase);
	}
	if (IntuitionBase) {
		CloseLibrary(IntuitionBase);
	}
	printf("ai: exit\n");
}
