/*
 *  clibtest.c -- C example that calls the Sample.library functions
 *
 *  Copyright 1988 Commodore Amiga Inc.  All rights reserved.
 *
 *  Linkage Info:
 *  FROM     Astartup.obj, clibtest.o
 *  LIBRARY  LIB:amiga.lib, LIB:sample.lib
 *  TO       CLibTest
 */


#include <exec/types.h>
#include <exec/libraries.h>
#include <libraries/dos.h>

#include "samplebase.h"

struct SampleBase *SampleBase;

void main()
   {
   LONG n;
   struct Library *slib;

   /* Open sample.library */
   if(!(SampleBase=(struct SampleBase *)OpenLibrary("sample.library",0)))
      {
      printf("Can't open sample.library\n");
      exit(RETURN_FAIL);
      }

   /* Print library name, version, revision */
   slib = &SampleBase->LibNode;
   printf("%s   Version %ld   Revision %ld\n",
             slib->lib_Node.ln_Name, slib->lib_Version, slib->lib_Revision);

   /* Call the two functions */
   n = Double(-7);
   printf("Function Double(-7) returned %ld\n", n);

   n = AddThese(21,4);
   printf("Function AddThese(21,4) returned %ld\n", n);

   CloseLibrary(SampleBase);
   exit(RETURN_OK);
   }
