
/* The following code fragments and notes aid in writing
 * internationally compatible code.
 */



/* To determine video format (PAL/NTSC) at runtime:
 */
#include <graphics/gfxbase.h>

struct GfxBase *GfxBase;

GfxBase = (struct GfxBase *) OpenLibrary("graphics.library", 0L);
if ( GfxBase == NULL) /*  Couldn't open library; clean up and exit.  */

if (GfxBase->DisplayFlags & PAL)
   {
   /*  It's a PAL machine */
   }
else if (GfxBase->DisplayFlags & NTSC) 
   { 
   /*  It's an NTSC machine.  */
   }
else
   {
   /* It's neither */
   }




/* When calculating audio period from frequency:
 */
The NTSC clock constant is 3.579545.
The PAL clock constant is  3.546895.




/* Here are tolower() and toupper(), text routines which will correctly
 * handle international characters.  See p226 of "The AmigaDOS Manual, 2nd Ed."
 * (Bantam 1987) for a chart of the ASCII characters.
 */

/*
    T O L O W E R
    Converts upper case letters to their lower case counterparts.
    This is a 'C' version of Bob Burns' deCase assembler code.
*/

#ifdef tolower
#undef tolower
#endif
#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

char tolower(c)
char c;
{
UBYTE u;
    u = c;
    if ((u >= 0x41 && u <= 0x5a) ||
        (u >= 0xc0 && u <= 0xd6) || 
        (u >= 0xd8 && u <= 0xde)) c |= 0x20;

    return(c);
}



/*
    T O U P P E R
    Converts lower case letters to their upper case counterparts.
    This is a 'C' version of Bob Burns' deCase assembler code.
*/

#ifdef toupper
#undef toupper
#endif
#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

char toupper(c)
char c;
{
UBYTE u;
    u = c;
    if ((u >= 0x61 && u <= 0x7a) ||
        (u >= 0xe0 && u <= 0xf6) || 
        (u >= 0xf8 && u <= 0xfe)) c &= 0xdf;

    return(c);

}



/* If your code gets its keyboard input through the console.device,
 * CON:, RAW:, or IDCMP VANILLAKEY messages, you get automatic
 * international keymap character translation and automatic
 * handling of deadkeys.  However, if you are using IDCMP RAWKEY
 * messages, you must use the following routine to properly convert
 * your raw key values to the correct ascii codes based on the keymap.
 * (national keyboards have some different keycaps/ascii values for
 * some keyboard locations)
 * Code by Jim Mackraz
 */

    /* must have the ConsoleDevice opened to use RawKeyConvert() */
    struct Device *ConsoleDevice;       /* external declaration */
    struct IOStdReq ioreq;
        ...
    OpenDevice("console.device", -1, &ioreq, 0);
    ConsoleDevice = ioreq.io_Device;
        ...

    /* DeadKeyConvert()
     * returns:
     *  -2 if msg is not class RAWKEY
     *  same as RawKeyConvert otherwise:
     *  buffer length if <= kbsize
     *  -1 else
     */
    DeadKeyConvert(msg, kbuffer, kbsize, kmap)
    struct IntuiMessage *msg;
    UBYTE *kbuffer;
    int kbsize;
    struct KeyMap *kmap;
    {
        static struct InputEvent ievent = {NULL, IECLASS_RAWKEY, 0, 0, 0};

        if (msg->Class != RAWKEY) return (-2);

        /* pack input event */
        ievent.ie_Code = msg->Code;
        ievent.ie_Qualifier = msg->Qualifier;

        /* get previous codes from location pointed to by IAddress
         *  this pointer is valid until IntuiMessage is replied.
         */
         ievent.ie_position.ie_addr = *((APTR *)msg->IAddress);

        return ( RawKeyConvert(&ievent, kbuffer, kbsize, kmap) );
    }



