/*  :ts=8 bk=0
 * wiff.c:	Test IFF write program.  Writes junk, really.
 *		Alpha Concept Prototype.
 *
 * Usage: wiff [-c] [file]
 *
 * Writes a demo IFF file to the specified stream -- either a DOS file or
 * the clipboard's primary clip.
 *
 * Stuart Ferguson			8809.01
 *
 * Fixed bugs, added testing/illustration of client-supplied sizes.
 * ewhac				8811.02
 */
#include <libraries/dos.h>
#include <iff/iffparse.h>

#define	ID_ILBM	MAKE_ID('I','L','B','M')
#define	ID_BMHD	MAKE_ID('B','M','H','D')
#define	ID_BODY	MAKE_ID('B','O','D','Y')
#define	ID_CRNG	MAKE_ID('C','R','N','G')
#define	ID_TEST	MAKE_ID('T','E','S','T')

extern void	*OpenLibrary();
extern long	Open();
LONG		PropOut(), FormOut1(), FormOut2();

struct Library	*IFFParseBase;


main (argc, argv)
int	argc;
char	**argv;
{
	struct IFF_File		*iff = NULL;
	long			error;
	short			cbio;

	if (argc < 2) {
		printf ("usage: %s [-c] <outfile>\n", argv[0]);
		goto die;
	}

	cbio = (argv[1][0] == '-' && argv[1][1] == 'c');

	if (!(IFFParseBase = OpenLibrary ("iffparse.library", 0L))) {
		puts ("Cannot open library.");
		goto die;
	}

	if (!(iff = AllocIFF())) {
		puts ("AllocIFF() failed.");
		goto die;
	}

	if (cbio) {
		if (!(iff -> iff_Stream =
				(ULONG) OpenClipboard (PRIMARY_CLIP))) {
			puts ("Clipboard open failed.");
			goto die;
		}
		InitIFFasClip (iff);
		BeginCB_Write (iff);
	} else {
		if (!(iff -> iff_Stream = Open (argv[1], MODE_NEWFILE))) {
			puts ("File open failed.");
			goto die;
		}
		InitIFFasDOS (iff, IFFM_WRITE);
	}

	OpenIFF (iff);

	if (error = PushChunk (iff, ID_TEST, ID_LIST, IFFSIZE_UNKNOWN)) {
		puts ("Initial PushChunk() failed.");
		goto die;
	}
	if (error = PropOut (iff)) {
		puts ("PROP out failed.");
		goto die;
	}
	if (error = FormOut1 (iff)) {
		puts ("First FORM out died.");
		goto die;
	}
	if (error = FormOut2 (iff)) {
		puts ("Second FORM out died.");
		goto die;
	}
	if (error = PopChunk (iff)) {
		puts ("Final PopChunk() failed.");
		goto die;
	}

die:
	if (error)
		printf ("error code: %ld\n", error);

	if (iff) {
		if (cbio)
			EndCB_Write (iff);

		CloseIFF (iff);

		if (iff -> iff_Stream  &&  cbio)
			CloseClipboard (iff -> iff_Stream);
		else if (iff -> iff_Stream)
			Close (iff -> iff_Stream);

		FreeIFF (iff);
	}

	if (IFFParseBase)	CloseLibrary (IFFParseBase);
}


LONG
PropOut (iff)
struct IFF_File *iff;
{
	LONG	error;

	if (error = PushChunk (iff, ID_ILBM, ID_PROP, IFFSIZE_UNKNOWN))
		return (error);

	if (error = PushChunk (iff, 0L, ID_BMHD, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, "This is the BMHD.......", 20L) != 20)
		return (10);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, "a", 1L) != 1)
		return (11);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, "ab", 2L) != 2)
		return (12);
	if (error = PopChunk (iff))
		return (error);

	if (error = PopChunk (iff))
		return (error);

	return (0);
}


LONG
FormOut1 (iff)
struct IFF_File *iff;
{
	LONG	error;

	if (error = PushChunk (iff, ID_ILBM, ID_FORM, IFFSIZE_UNKNOWN))
		return (error);

	if (error = PushChunk (iff, 0L, ID_BODY, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, "I'm the Body.  Hi.", 18L) != 18)
		return (20);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, "abc", 3L) != 3)
		return (21);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, "abcd", 4L) != 4)
		return (22);
	if (error = PopChunk (iff))
		return (error);

	if (error = PopChunk (iff))
		return (error);

	return (0);
}


LONG
FormOut2 (iff)
struct IFF_File *iff;
{
	LONG	error;

	if (error = PushChunk (iff, ID_ILBM, ID_FORM, IFFSIZE_UNKNOWN))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, "abcde", 5L) != 5)
		return (30);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_CRNG, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, "abcdef", 6L) != 6)
		return (31);
	if (error = PopChunk (iff))
		return (error);

	if (error = PushChunk (iff, 0L, ID_BODY, IFFSIZE_UNKNOWN))
		return (error);
	if (WriteChunkBytes (iff, "I'm the Body.  Hi.", 18L) != 18)
		return (32);
	if (error = PopChunk (iff))
		return (error);

	if (error = PopChunk (iff))
		return (error);

	return (0);
}
