/*  :ts=8 bk=0
 * wiff.c:	Test IFF write program.  Writes junk, really.
 *		Alpha Concept Prototype.
 *
 * Usage: wiff [-c] [file]
 *
 * Writes a demo IFF file to the specified stream -- either a DOS file or
 * the clipboard's primary clip.
 *
 * Stuart Ferguson			8809.01
 *
 * Fixed bugs, added testing/illustration of client-supplied sizes.
 * ewhac				8811.02
 *
 * Updated to Dec 88 design revision
 * shf					8812.15
 */
#include <libraries/dos.h>
#include <iff/iffparse.h>

#define	ID_FTXT	MAKE_ID('F','T','X','T')
#define	ID_CHRS	MAKE_ID('C','H','R','S')
#define	ID_FNAM	MAKE_ID('F','N','A','M')
#define	ID_ZOID	MAKE_ID('Z','O','I','D')

extern void	*OpenLibrary();
extern long	Open();
LONG		TextChunkOut(), TestChunkOut();

struct Library	*IFFParseBase;

main (argc, argv)
int	argc;
char	**argv;
{
	struct IFF_File		*iff = NULL;
	long			error;
	short			cbio;

	if (argc < 2) {
		printf ("usage: %s [-c] <outfile>\n", argv[0]);
		goto die;
	}
	cbio = (argv[1][0] == '-' && argv[1][1] == 'c');

	if (!(IFFParseBase = OpenLibrary ("iffparse.library", 0L))) {
		puts ("Can't get IFF parse library\n");
		goto die;
	}

	if (!(iff = AllocIFF())) {
		puts ("AllocIFF() failed.");
		goto die;
	}

	if (cbio) {
		if (!(iff -> iff_Stream =
				(ULONG) OpenClipboard (PRIMARY_CLIP))) {
			puts ("Clipboard open failed.");
			goto die;
		}
		InitIFFasClip (iff);
		BeginCB_Write (iff);
	} else {
		if (!(iff -> iff_Stream = Open (argv[1], MODE_NEWFILE))) {
			puts ("File open failed.");
			goto die;
		}
		InitIFFasDOS (iff, IFFM_WRITE);
	}

	OpenIFF (iff);

	if (error = PushChunk (iff, ID_ZOID, ID_LIST, IFFSIZE_UNKNOWN)) {
		printf ("Initial PushChunk() error %ld\n", error);
		goto die;
	}
	if (error = PushChunk (iff, ID_FTXT, ID_FORM, IFFSIZE_UNKNOWN)) {
		printf ("Initial PushChunk() error %ld\n", error);
		goto die;
	}
	if (error = TestChunkOut (iff)) {
		printf ("Test out error %ld.\n", error);
		goto die;
	}

	if (error = TextChunkOut (iff, "This is a test")) {
		printf ("Text out error %ld.\n", error);
		goto die;
	}
	if (error = TextChunkOut (iff, "And another")) {
		printf ("Text out error %ld.\n", error);
		goto die;
	}
	if (error = PopChunk (iff)) {
		printf ("penFinal PopChunk() error %ld\n", error);
		goto die;
	}
	if (error = PopChunk (iff)) {
		printf ("Final PopChunk() error %ld\n", error);
		goto die;
	}

die:
	if (iff) {
		if (cbio)
			EndCB_Write (iff);

		CloseIFF (iff);

		if (iff -> iff_Stream  &&  cbio)
			CloseClipboard (iff -> iff_Stream);
		else if (iff -> iff_Stream)
			Close (iff -> iff_Stream);

		FreeIFF (iff);
	}

	if (IFFParseBase)	CloseLibrary (IFFParseBase);
}


LONG
TextChunkOut (iff, str)
struct IFF_File *iff;
char		*str;
{
	LONG	error, size;

	if (error = PushChunk (iff, 0L, ID_CHRS, IFFSIZE_UNKNOWN))
		return (error);

	size = strlen (str);
	if (WriteChunkRecords (iff, str, 1L, size) != size)
		return (IFFERR_WRITE);

	printf ("wrote chunk <%s>\n", str);

	if (error = PopChunk (iff))
		return (error);

	return (0);
}


LONG
TestChunkOut (iff)
struct IFF_File *iff;
{
	LONG	error, size;

	size = 10;
	if (error = PushChunk (iff, 0L, ID_FNAM, size))
		return (error);

	if (WriteChunkBytes (iff, "fname67890", size) != size)
		return (-100);

	if (error = PopChunk (iff))
		return (error);

	return (0);
}
