/*  :ts=8 bk=0
 *
 * tiff2.c:	Frame concept ILBM scanner.
 * 		Alpha Concept Prototype.
 *
 * All the code needed for an ILBM reader, except the stuff to process the
 * ILBM itself.  New one with a twist - the "frame" idea.
 *
 * Managing all the interactions of end of context and properties and
 * data chunks is kind of a hassle to get right without groking all the
 * complexities of recursive data structures and parsing, etc.  Frames
 * are an idea to make things a little easier.  The client just creates
 * a frame structure and a couple of handlers for dealing with them in
 * a generic way.  Then the client just has to fill in the details of the
 * frame by handling data chunks himself.  At the end of the context, 
 * the client gets handed a completed frame and he can go about his
 * business without concern for what got partly done or whatever.
 *
 * Stuart Ferguson				8901.02
 *
 * NOTE: This sucker ain't like, totaly done.  I'll pop it in the post 
 *       as soon as I can make it work, Leo.
 */
#include <exec/types.h>
#include <libraries/dos.h>
#include <iff/iffparse.h>

#define	ID_ILBM	MAKE_ID('I','L','B','M')
#define	ID_BODY	MAKE_ID('B','O','D','Y')
#define	ID_BMHD	MAKE_ID('B','M','H','D')
#define	ID_CMAP	MAKE_ID('C','M','A','P')
#define	ID_CAMG	MAKE_ID('C','A','M','G')
#define	ID_CRNG	MAKE_ID('C','R','N','G')

extern void	*OpenLibrary(), *AllocMem();
extern long	Open();


static long	ilbmprops[] = {
	ID_ILBM, ID_BMHD,
	ID_ILBM, ID_CMAP,
	ID_ILBM, ID_CAMG
};

static long	ilbmstops[] = {
	ID_ILBM, ID_BODY,
	ID_ILBM, ID_CRNG,
};


#define MAXCRNG	8

/*
 * The "Frame" for a complete ILBM.  This stupid one will just be the
 * sizes of each chunk (just to show that it works).
 */
struct ILBMframe {
	LONG bmhd,body,cmap,camg;
	int ncrng;
	LONG crng[MAXCRNG];
};


static struct ILBMframe	*CreateILBMframe();
static LONG		FreeILBMframe(), EnterFrame(), FramePurge();
struct Frame		*FindFrame();
LONG			MakeFrame();

struct Library	*IFFParseBase;
extern LONG	GenericStub();
#define CALL_ME	GenericStub


main (argc, argv)
int	argc;
char	**argv;
{
	struct IFF_File		*iff;
	struct ContextNode	*top;
	struct ILBMframe	*fr;
	long			error;
	int			foundilbm = 0;

	if (!(IFFParseBase = OpenLibrary ("iffparse.library", 0L))) {
		puts ("Cannot open library.");
		goto die;
	}

	/*
	 * Create IFF file and open a DOS stream on it.
	 */
	if (!(iff = AllocIFF())) {
		puts ("AllocIFF() failed.");
		goto die;
	}

	if (!(iff -> iff_Stream = Open (argv[1], MODE_OLDFILE))) {
		puts ("File open failed.");
		goto die;
	}
	InitIFFasDOS (iff, IFFM_READ);

	/*
	 * Declare frame handlers for the ILBM format.
	 */
	if (error = MakeFrame (iff, ID_ILBM, CreateILBMframe, FreeILBMframe))
		goto err;

	/*
	 * Declare property, collection and stop chunks.
	 * (You still have to do this because YOU handle the data.)
	 */
	if (error = PropChunks (iff, ilbmprops, 3L))
		goto err;
	if (error = StopChunks (iff, ilbmstops, 2L))
		goto err;

	OpenIFF (iff);

	error = 0;
	while (!error) {
		/*
		 * ParseIFF() will return on BODY and CRNG chunks
		 * or when the frame is filled.  In any case, we 
		 * should nab a frame for this context (even if
		 * it's really NULL).
		 */
		error = ParseIFF (iff, IFFPARSE_SCAN);
		fr = (struct ILBMframe *) FindFrame (iff, ID_ILBM);

		/*
		 * At end of context, do something with the finished frame.
		 * This code will scan and do the same thing with all the
		 * ILBM FORM's in the file.
		 */
		if (error == IFFERR_EOC) {
			foundilbm = 1;
			DisplayILBM (fr);
			error = 0;
			continue;
		}

		/*
		 * Other errors are real and possibily nasty errors.
		 */
		if (error)
			break;

		/*
		 * We've hit data.  Switch and decode.
		 * Make sure it's inside a FORM, otherwise storing
		 * data into the frame (if there even is one) is wrong.
		 */
		top = CurrentChunk (iff);
		if (ParentChunk (top) -> cn_ID == ID_FORM)
			switch (top -> cn_ID) {
			    case ID_BODY:
				ProcessBody (iff, fr);
				break;
			    case ID_CRNG:
				ProcessCycle (iff, fr);
				break;
			}
	}
err:
	if (error == IFFERR_EOF) {
		if (foundilbm)
			puts ("File scan complete.");
		else
			puts ("Failed to find a FORM ILBM.");
	} else
		printf ("File scan aborted (%ld)\n", error);

die:
	if (iff) {
		CloseIFF (iff);
		if (iff -> iff_Stream)
			Close (iff -> iff_Stream);
		FreeIFF (iff);
	}

	if (IFFParseBase)	CloseLibrary (IFFParseBase);
}


/*
 * Just show that something happened.
 */
DisplayILBM (fr)
struct ILBMframe	*fr;
{
	int	i;

	printf ("A Picture:  BMHD:%ld, CMAP:%ld, CAMG:%ld, BODY:%ld\n",
		fr -> bmhd, fr -> cmap, fr -> camg, fr -> body);
	if (fr -> ncrng) {
		for (i = 0; i < fr -> ncrng; i++)
			printf ("CRNG:%ld  ", fr -> crng[i]);
		printf ("\n");
	} else
		printf ("No CRNG chunks.\n");
}


/*
 * Process a BODY chunk in an ILBM.  Just get the sizes of the various
 * properties and data for now.
 */
ProcessBody (iff, fr)
struct IFF_File 	*iff;
struct ILBMframe	*fr;
{
	register struct StoredProperty	*sp;

	printf ("Body.\n");

	if (sp = FindProp (iff, ID_ILBM, ID_BMHD))
		fr -> bmhd = sp -> sp_Size;

	if (sp = FindProp (iff, ID_ILBM, ID_CMAP))
		fr -> cmap = sp -> sp_Size;

	if (sp = FindProp (iff, ID_ILBM, ID_CAMG))
		fr -> camg = sp -> sp_Size;

	fr -> body = CurrentChunk (iff) -> cn_Size;
}


ProcessCycle (iff, fr)
struct IFF_File 	*iff;
struct ILBMframe	*fr;
{
	printf ("Cycle.\n");

	fr -> crng[fr -> ncrng ++] = CurrentChunk (iff) -> cn_Size;
}


/*
 * Demi-handler to create a new frame and init to default values.
 * The IFF is provided in case any default values are there.
 */
static struct ILBMframe *
CreateILBMframe (iff)
struct IFF_File	*iff;
{
	struct ILBMframe	*f;

	if (!(f = (struct ILBMframe *) AllocMem ((LONG) sizeof (*f), 0L)))
		return NULL;
	printf ("Creating new frame: %lx\n", f);

	f -> bmhd = f -> body = f -> cmap = f -> camg = -1;
	f -> ncrng = 0;
	return f;
}


/*
 * Client call-back to free up his frame.  Deletes frame and all
 * associated memory.
 */
static LONG
FreeILBMframe (f)
struct ILBMframe	*f;
{
	printf ("Freeing frame: %lx\n", f);
	FreeMem (f, (LONG) sizeof (*f));
	return (0);
}


/*
 * ====
 * This stuff would be in the library to make the Frame management
 * capability available to all.
 * ====
 */

struct FrameDescriptor {
	struct Frame		*(*fd_Create)();
	LONG			(*fd_Delete)();
};

struct FrameInstance {
	struct Frame		*fi_Frame;
};

#define IFFLCI_FRAMEDESC	MAKE_ID('f','d','e','s')
#define IFFLCI_FRAME		MAKE_ID('f','r','a','m')

/*
 * Declare the handlers for a frame.  Client provides functions for
 * creating and deleting frames and the library will call them at the
 * appropriate times (entering and exiting the specified FORM).  These
 * function vectors get stored in a frame descriptor which will be
 * used by the generic entry and exit handlers.
 */
LONG
MakeFrame (iff, type, create_f, delete_f)
struct IFF_File	*iff;
LONG		type;
struct Frame	*(*create_f)();
LONG		(*delete_f)();
{
	register struct LocalContextItem *lci;
	register struct FrameDescriptor	 *fd;
	register LONG			  error;

	if (!(lci = AllocLocalItem (IFFLCI_FRAMEDESC,
			type, 0L, (long) sizeof (*fd))))
		return (IFFERR_NOMEM);

	fd = (struct FrameDescriptor *) LocalItemData (lci);
	fd -> fd_Create = create_f;
	fd -> fd_Delete = delete_f;

	if (error = StoreLocalItem (iff, lci, IFFSLI_TOP))
		goto fail;
	if (error = EntryHandler
	  (iff, type, ID_FORM, EnterFrame, CALL_ME, IFFSLI_TOP))
		goto fail;
	if (error = StopOnExit (iff, type, ID_FORM))
		goto fail;
	return (0);

fail:
	FreeLocalItem (lci);
	return (error);
}


/*
 * Returns the current frame for the given context.
 */
struct Frame *
FindFrame (iff, type)
struct IFF_File	*iff;
LONG		type;
{
	struct LocalContextItem *lci;

	if (!(lci = FindLocalItem (iff, IFFLCI_FRAME, type, 0L)))
		return (NULL);

	return (((struct FrameInstance *) LocalItemData (lci)) -> fi_Frame);
}


/*
 * On entering the FORM associated with a frame, create a new
 * frame and store it for this context.
 */
static LONG
EnterFrame (iff, cn, D0, D1)
struct IFF_File		*iff;
struct ContextNode	*cn;
LONG			D0, D1;
{
	struct LocalContextItem *lci;
	struct FrameInstance	*fi;
	struct FrameDescriptor	*fd;
	LONG			error, type;

	type = cn -> cn_Type;

	if (!(lci = FindLocalItem (iff, IFFLCI_FRAMEDESC, type, 0L)))
		return (IFFERR_NOSCOPE);

	fd = (struct FrameDescriptor *) LocalItemData (lci);

	if (!(lci = AllocLocalItem (IFFLCI_FRAME,
				type, 0L, (LONG) sizeof (*fi))))
		return (IFFERR_NOMEM);
	fi = (struct FrameInstance *) LocalItemData (lci);

	if (!(fi -> fi_Frame = (*(fd -> fd_Create)) (iff))) {
		error = IFFERR_NOMEM;
		goto fail;
	}
	SetLocalItemPurge (lci, FramePurge, CALL_ME);

	if (error = StoreLocalItem (iff, lci, IFFSLI_TOP))
		goto fail;
	return (0);

fail:
	FreeLocalItem (lci);
	return (error);
}


/* What's this, Stu?
 *
 * Hmmm..  What's what?  <whistle, whistle ...>
 *
static LONG
ExitFrame (iff, cn, D0, D1)
struct IFF_File		*iff;
struct ContextNode	*cn;
LONG			D0, D1;
{
}
 *
 */


LONG
FramePurge (iff, lci, D0, D1)
struct IFF_File		*iff;
struct LocalContextItem *lci;
LONG			D0, D1;
{
	struct FrameInstance	*fi;
	struct FrameDescriptor	*fd;

	fi = (struct FrameInstance *) LocalItemData (lci);

	fd = (struct FrameDescriptor *) LocalItemData (FindLocalItem
		(iff, IFFLCI_FRAMEDESC, lci -> lci_Type, 0L));

	(*(fd -> fd_Delete)) (fi -> fi_Frame);

	FreeLocalItem (lci);
	return (0);
}
