/*  :ts=8 bk=0
 *
 * simple.c:	Demonstrates the basic steps required in doing the simplest
 *		possible IFF file parsing.  This program doesn't actually
 *		*do* anything; it just illustrates how the rudimentary stuff
 *		is done.
 *	SYNOPSIS:
 *		simple <filename>
 *
 *		WARNING:  Error checking has been deleted for reasons of
 *		clarity.  Do *not* use this as a model of How To Do It
 *		Properly In The Real World.
 *
 * Leo L. Schwab				8902.23
 */
#include <exec/types.h>
#include <libraries/dosextens.h>
#include <iff/iffparse.h>

extern void	*OpenLibrary();
extern LONG	Open();

struct Library	*IFFParseBase;


main (argc, argv)
int	argc;
char	**argv;
{
	struct IFF_File	*iff;
	long		error;

	/*
	 * Let me say it again.  Error checking has been deleted for clarity.
	 * A Real program *MUST* have error checking in it.
	 */
	IFFParseBase = OpenLibrary ("iffparse.library", 0L);

	/*
	 * Allocate the IFF_File structure.  This is the only supported way
	 * to allocate an IFF_File structure.  Declaring a static structure
	 * won't do it, since there are private fields not declared in the
	 * iff.h file.  Thus, sizeof (struct IFF_File), as far as you're
	 * concerned, is too small.  AllocIFF(), however, will get it right
	 * every time, in all current and future releases.
	 */
	iff = AllocIFF ();

	/*
	 * Set up the iff_Stream field.  This field is not used by the
	 * iffparse.library itself, but is instead passed to the client's
	 * read, write, and seek routines, which the library invokes.  This
	 * means that iff_Stream can represent anything you wish, since it
	 * will be your routines that will interpret it.  In this example,
	 * we're opening an AmigaDOS file.
	 */
	iff -> iff_Stream = Open (argv[1], MODE_OLDFILE);

	/*
	 * As a convenience, iffparse.library provides call-back routines for
	 * direct DOS manipulation internally.  This routine points the
	 * IFF_File's private call-back vectors at those internal routines,
	 * saving you the trouble of having to declare them yourself (in your
	 * own code space).  The read/write mode of the stream is also set
	 * here, by ORing in to the IFF_File.iff_Flags field.
	 */
	InitIFFasDOS (iff, IFFM_READ);

	/*
	 * This "opens" the IFF_File stream for transaction.  This
	 * initializes internal state only; no reading of the file is done.
	 */
	OpenIFF (iff);

	/*
	 * This this the biggie.  As used in this example, this routine will
	 * trip happily along through the file, verifying syntax, until it
	 * hits end-of-file, at which point, it will return the value
	 * IFFERR_EOF.
	 */
	error = ParseIFF (iff, IFFPARSE_SCAN);

	/*
	 * If we didn't get IFFERR_EOF back, then something went wrong while
	 * scanning the file.  Print out the error code as a diagnostic.
	 * (A better approach would be to use the error code as an index into
	 * an array of strings, and print the appropriate string.)
	 */
	if (error != IFFERR_EOF)
		printf ("Abnormal termination:  error = %ld\n", error);

	/*
	 * Terminate the transaction with the IFF_File.  This routine may
	 * be called at any time.  All dynamically allocated structures
	 * are freed by this call (except the IFF_File structure itself).
	 */
	CloseIFF (iff);

	/*
	 * Close the I/O stream we opened.  (A DOS file in this example.)
	 */
	Close (iff -> iff_Stream);

	/*
	 * Free the IFF_File structure itself.
	 */
	FreeIFF (iff);

	CloseLibrary (IFFParseBase);
}
