*\ :ts=8 bk=0
*
* iff.i:	Assembly include file for iffparse.library.
*		Generated by hand from iff.h (as of 8902.22)
*
* Leo L. Schwab					8902.22
********
* Copyright 1989 Stuart H. Ferguson and Leo L. Schwab.  All Rights Reserved.
* Use of this file in the creation of a commercial product without the
* prior written consent of the Copyright holders is prohibited.
*
* Dissemination of this file without prior written consent is prohibited.
*
* If you have suggestions for improvements to the parser, we'd like to hear
* them.  Send them to either of the addresses below, and we'll look them
* over.  Thanks!
*
* Stuart H. Ferguson			Leo L. Schwab
* 123 James Ave.			23 Summerhill Court
* Redwood City, CA   94062		Terra Linda, CA   94903-3873
* well!shf@ucbvax.Berkeley.EDU		well!ewhac@ucbvax.Berkeley.EDU
*/
		IFND	IFF_IFFPARSE_I
IFF_IFFPARSE_I	SET	1

		IFND	EXEC_TYPES_I
		include 'exec/types.i'
		ENDC

		IFND	EXEC_LISTS_I
		include	'exec/lists.i'
		ENDC

		IFND	EXEC_PORTS_I
		include	'exec/ports.i'
		ENDC

		IFND	DEVICES_CLIPBOARD_I
		include	'devices/clipboard.i'
		ENDC

*\
* Struct associated with an active IFF file.
* "iff_Stream" is a value used by the read/write functions -
* it will not be accessed by the library itself and can have any value
* (could even be a pointer or a BPTR).
**
* ewhac:  Philosophical problem.  ULONG implies "big unsigned int".  APTR
* implies "pointer to something".  It just so happens that sizeof (ULONG) ==
* sizeof (APTR).  What if someone comes along with a long that's 64 bits
* wide?  Does exec/types.h get hacked by CBM to maintain the element sizes?
* (A pretty strong argument can be made in favor of that.)
*/
	STRUCTURE IFF_File,0
		ULONG	iff_Stream
		ULONG	iff_Flags
		LONG	iff_Depth
* There are private fields hiding here.
	LABEL	iff_SIZEOF

*\
* Bit masks for "flags" field.
*/
IFFM_READ	EQU	0L			; read mode - default
IFFM_WRITE	EQU	1L			; write mode
IFFM_FSEEK	EQU	1<<1			; forward seek only
IFFM_RSEEK	EQU	1<<2			; random seek
IFFM_MODE	EQU	IFFM_READ!IFFM_WRITE	; read/write bit

*\
* A node associated with a context on the iff_Stack.  Each node
* represents a chunk, the stack representing the current nesting 
* of chunks in the open IFF file.  Each context node has associated
* local context items in the LocalItems list.  The ID, type, size and
* scan values describe the chunk associated with this node.
*/
	STRUCTURE ContextNode,MLN_SIZE		; cn_Node
		LONG	cn_ID
		LONG	cn_Type
		LONG	cn_Size
* There are private fields hiding here.
	LABEL	cn_SIZEOF

*\
* Local context items live in the ContextNode's.  Each class 
* is identified by its lci_Ident code and has a purge vector for
* when the parent context node is popped.
*/
	STRUCTURE LocalContextItem,MLN_SIZE	; lci_Node
		ULONG	lci_Ident
		ULONG	lci_ID
		ULONG	lci_Type
* There are private fields hiding here.
	LABEL	lci_SIZEOF

*\
* StoredProperty: a local context item containing the data stored
* from a previously encountered property chunk.
*/
	STRUCTURE StoredProperty,0
		LONG	sp_Size
		APTR	sp_Data
	LABEL	sp_SIZEOF

*\
* Collection Item: the actual node in the collection list that the
* client will look at.  The next pointers cross context boundaries
* so that the complete list is accessable.
*/
	STRUCTURE CollectionItem,0
		APTR	ci_Next
		LONG	ci_Size
		APTR	ci_Data
	LABEL	ci_SIZEOF

*\
* Issue (shf): Should this be here, or should it be private to iffi.c?
**
* ewhac:  I think it should be public.  It has general use outside of
* IFF applications.  Privatizing it also makes it real hard to do POST
* commands to the clipboard.
*/
	STRUCTURE ClipboardHandle,iocr_SIZEOF	; cbh_Req
		STRUCT	cbh_CBport,MP_SIZE
		STRUCT	cbh_SatisfyPort,MP_SIZE
	LABEL	cbh_SIZEOF

*\
* IFF return codes.  Most functions return either zero for success or
* one of these codes.  The exception are the read/write functions which
* return positive values for number of bytes or records read or written,
* or a negative error code.  Some of these codes are not errors per sae,
* but valid conditions such as EOF or EOC (End of Chunk).
*/
IFFERR_EOF		EQU	-1
IFFERR_EOC		EQU	-2
IFFERR_NOSCOPE		EQU	-3
IFFERR_NOMEM		EQU	-4
IFFERR_READ		EQU	-5
IFFERR_WRITE		EQU	-6
IFFERR_SEEK		EQU	-7
IFFERR_MANGLED		EQU	-8
IFFERR_SYNTAX		EQU	-9
IFFERR_NOTIFF		EQU	-10
IFF_RETURN2CLIENT	EQU	-11

*\
* Universal IFF identifiers.
*/
ID_FORM			EQU	'FORM'
ID_LIST			EQU	'LIST'
ID_CAT			EQU	'CAT '
ID_PROP			EQU	'PROP'

*\
* Ident codes for universally recognized local context items.
*/
IFFLCI_PROP		EQU	'prop'
IFFLCI_COLLECTION	EQU	'coll'
IFFLCI_ENTRYHANDLER	EQU	'enhd'
IFFLCI_EXITHANDLER	EQU	'exhd'

*\
* Control modes for ParseIFF() function.
*/
IFFPARSE_SCAN		EQU	0
IFFPARSE_STEP		EQU	1
IFFPARSE_RAWSTEP	EQU	2

*\
* Control modes for StoreLocalItem().
*/
IFFSLI_ROOT		EQU	1
IFFSLI_TOP		EQU	2
IFFSLI_PROP		EQU	3

*\
* "Flag" for writing functions.  If you pass this value in as a size
* to PushChunk() when writing a file, the parser will figure out the
* size of the chunk for you.  (Chunk sizes >= 2**31 are forbidden by the
* IFF specification, so this works.)
*/
IFFSIZE_UNKNOWN		EQU	-1

		ENDC	; IFF_IFFPARSE_I
