/* A test program to demonstrate the direct variable interface to ARexx.
 * Opens a public port called "VarTest" and then waits for REXX messages.
 * The port stays open until a "CLOSE" command is received.
 * Usage:  run vartest
 * Then send commands from within ARexx by "address 'VarTest' command"
 *
 *    This version for Manx. WGL
 */

#include "exec/types.h"

#include "rexx/storage.h"
#include "rexx/rxslib.h"

#include <stdio.h>
#include <functions.h>

#define VALUE "A-OK"

struct RexxLib *RexxSysBase;

extern LONG  CheckRexxMsg();
extern LONG  GetRexxMsg();
extern LONG  SetRexxMsg();

main(argc,argv)
int argc;
char **argv;
{
   struct MsgPort MyPort;
   struct RexxMsg *rmptr;
   LONG           test,error;
   STRPTR         value;

   RexxSysBase = (struct RexxLib *) 
                 OpenLibrary("rexxsyslib.library",(LONG) RXSVERS);
   if (RexxSysBase == 0L) {
      printf("Bad News -- no REXX library\n");
      return(20L);
      }

   /* Initialize our message port   */
   InitPort(&MyPort,"VarTest");

   /* Make the port public          */
   AddPort(&MyPort);

   for (;;) {                          /* wait for messages             */
      Wait(1L<<MyPort.mp_SigBit);
      rmptr = (struct RexxMsg *) GetMsg(&MyPort);

      /* Show what we got           */
      printf("VarTest: received command %s\n",rmptr->rm_Args[0]);

      /* Make sure it's a valid context */
      if (CheckRexxMsg(rmptr)) {
         printf("VarTest: valid REXX context\n");

         if ((error = GetRexxVar(rmptr,"A.1",&value)) == 0L)
            printf("VarTest: value of A.1 is %s\n",value);
         else printf("VarTest: error from get %ld\n",error);

         error = SetRexxVar(rmptr,"STATUS",VALUE,strlen(VALUE));
         if (error != 0L) printf("VarTest: error from set %ld\n",error);
         }

      /* See whether it's the close command                             */
      test = strcmp(rmptr->rm_Args[0],"CLOSE");

      rmptr->rm_Result1 = 0L;           /* return code                   */
      rmptr->rm_Result2 = 0L;           /* secondary result              */
      ReplyMsg(rmptr);                 /* send it back                  */

      if (test == 0L) break;            /* all done?                     */
      }

   RemPort(&MyPort);                   /* unlink it                     */
   FreePort(&MyPort);                  /* release the port resources    */

   return(0L);
}
