/* strhooks.c -- string gadget hooks	*/

/*
Copyright (c) 1989 Commodore-Amiga, Inc.

Executables based on this information may be used in software
for Commodore Amiga computers. All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#include "sysall.h"
#include "strgad.h"

struct IHook	tabhook;
struct IHook	cyclehook;

/* forward in this file	*/
VOID	tabh();
VOID	cycleh();

#define TABSCAN	(0x42)

#define SHIFTY (IEQUALIFIER_LSHIFT|IEQUALIFIER_RSHIFT)

#define D( x )	;	/* debugging: on 'x', off ';'	*/

initMyHooks()
{
    initHook( &tabhook, tabh );
    initHook( &cyclehook, cycleh );
}

initHook( hook, ccode )
struct IHook	*hook;
VOID		(*ccode)();
{
    ULONG	hookface();	/* assembler hook interface	*/
    hook->ih_Entry = hookface;
    hook->ih_SubEntry = (ULONG (*)()) ccode;
    hook->ih_Reserved = 0;
}


VOID
tabh( sgw, msg )
struct SGWork	*sgw;
ULONG		*msg;
{
    D( kprintf("tabh: sgw: %lx\n", sgw ) );

    if ( ( *msg == SGH_KEY ) && ( sgw->IEvent->ie_Code == TABSCAN ) )
    {
	sgw->Code = (sgw->IEvent->ie_Qualifier & SHIFTY)?
	    MYCODEBACKTAB: MYCODETAB;
	sgw->Actions |= SGA_END;
	sgw->Actions &= ~SGA_USE;
    }
}

UBYTE	*choices[] = {
    (UBYTE *) "choice 1",
    (UBYTE *) "choice 2",
    (UBYTE *) "choice 3",
    (UBYTE *) "choice 4",
    (UBYTE *) "choice 5",
    (UBYTE *) "choice 6",
};

#define NUMCHOICES	((sizeof (choices))/sizeof (UBYTE *))
#define UPARROW		(0x4c)
#define DOWNARROW	(0x4d)

VOID
cycleh( sgw, msg )
struct SGWork	*sgw;
ULONG		*msg;
{
    static int	choice = 0;

    D( kprintf("cycleh: %lx, sgw: %lx\n", sgw ) );

    if ( *msg != SGH_KEY ) return;

    switch ( sgw->IEvent->ie_Code )
    {
    case TABSCAN:
	sgw->Code = (sgw->IEvent->ie_Qualifier & SHIFTY)?
	    MYCODEBACKTAB: MYCODETAB;
	sgw->Actions |= SGA_END;
	sgw->Actions &= ~SGA_USE;
	break;

    case UPARROW:
	sgw->WorkBuffer = choices[ choice = (choice + 1)%NUMCHOICES ];
	sgw->NumChars = strlen( sgw->WorkBuffer );
	break;

    case DOWNARROW:
	sgw->WorkBuffer = choices[choice=(choice+(NUMCHOICES-1))%NUMCHOICES];
	sgw->NumChars = strlen( sgw->WorkBuffer );
	break;
    }
}

