/* strgad.h -- easy to build string gadgets 	*/

/*
Copyright (c) 1989 Commodore-Amiga, Inc.

Executables based on this information may be used in software
for Commodore Amiga computers. All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

struct SGSpec	{
	struct RastPort	*sgs_RPort;	/* screen rastport		*/
	WORD	sgs_TxHeight;		/* height of gadget font	*/
	WORD	sgs_Left;
	WORD	sgs_Top;
	WORD	sgs_Width;		/* used for borders		*/
	char	*sgs_Title;		/* placed on left (NOT COPIED!)	*/
	char	*sgs_InitString;	/* initial contents of buffer	*/
	WORD	sgs_NumChars;		/* i'll add NULL terminator	*/
	WORD	sgs_StringActives;	/* str. gadg. specific Activation*/
	WORD	sgs_ID;			/* gadget ID			*/
};

struct Gadget *getStringGadgets();
struct Gadget *freeStringGadgets();

#define TITLEGAP	(12)	/* space between title and gadget	*/
#define BORDERGAP	(2)
#define SGHEIGHT( rp )	(((rp)->TxHeight) + 4 + 2 * BORDERGAP)

/* internal communication	*/
#define MYCODETAB	1
#define MYCODEBACKTAB	2

