
; hookface.asm -- register-to-Aztec C conversion of IHook 
;	calling convention.

* Copyright (c) 1989 Commodore-Amiga, Inc.
* 
* Executables based on this information may be used in software
* for Commodore Amiga computers. All other rights reserved.
* This information is provided "as is"; no warranties are made.
* All use is at your own risk, and no liability or responsibility
* is assumed.

;
; You provide an IHook structure to a system routine to establish
; a "callback."  The IHook contains a pointer to a subroutine,
; such as hookface, below, a secondary pointer possibly to
; a high-level language subroutine, and a reserved word of zero.
;
; When your function is called, you are passed a pointer to the IHook,
; to which you can append user data.
;
; You are also passed a pointer to a data "object" and a pointer
; to a "message packet."  The message packet starts off with a
; pointer to a command ID ("message ID").


	cseg
	public _hookface
	public _geta4

	; this function is called with the following registers:
	;	A0	- pointer to "hook," as provided to system
	;	A1	- object, principle data parameter
	;	A2	- pointer to message data packet
	;	A6	- base of library calling this function
	;
	; hookface calls the C function whose address is at
	; 4(a0) in the following way:
	;
	; 	CMethod( object, message [, library] );
	;
	; where 'message' is a pointer to a parameter packet
	; with structure that depends on the message being handled.
	; It always begins with a copy of the message_id.
	;
	;	struct { LONG	message_id; ... } *message
	;
	; Note that if you want to be passed the hook in the
	; C routine, you'll have to modify this routine.
	;
	public _Debug

_hookface
	movem.l	a2/a4/a6/d2/d3,-(sp)	; protect 
	jsr	_geta4		; Aztec small model context

	; push parameters (some applications might want to push more)
	movem.l	a1/a2,-(sp)

	; jsr doubly-indirect
	pea.l	mfreturn(pc)

	move.l	4(a0),-(sp)	; 4(a0) is ih_SubEntry

	rts

mfreturn:
	lea	8(sp),sp	; parameters pop
	movem.l	(sp)+,a2/a4/a6/d2/d3	; restore

	rts
	end
