/* ellipse.c -- create ellipse image	*/

/*
Copyright (c) 1989 Commodore-Amiga, Inc.

Executables based on this information may be used in software
for Commodore Amiga computers. All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#include "sysall.h"

struct Image	*CreateImage();
struct RastPort	*CreateImageRPort();

#define D(x)	;

/*
 * dispose with DeleteImage()
 */
struct Image	*
CreateEllipseImage( width, height, depth, apen, bpen, hthick, vthick )
{
    struct Image	*im;
    struct RastPort	*rp;
    int		centerx, centery;

    D( printf("CEI: w %d h %d\n", width, height ) );

    if ( im = CreateImage( width, height, depth ) )
    {
    	if ( rp = CreateImageRPort( im ) )
	{
	    D( printf("CEI: rastport: %lx\n", rp ) );
	    centerx = (width - 1) / 2;
	    centery = (height - 1) / 2;
	    D( printf("cx %d cy %d\n", centerx, centery ) );

	    /* work around bug with area ellipse	*/
	    clearWords( rp->AreaInfo->FlagTbl,  5 );

	    D( printf("cei: doing fine\n") );

	    /* larger ellipse in border color	*/
	    SetAPen( rp, (long) bpen );
	    AreaEllipse( rp, (long) centerx, (long) centery,
	    	(long) centerx, (long) centery );
	    AreaEnd( rp );

	    D( printf("cei: still doing fine\n") );

	    SetAPen( rp, (long) apen );
	    AreaEllipse( rp, (long) centerx, (long) centery,
	    	(long) centerx - vthick, (long) centery - hthick );
	    AreaEnd( rp );

	    D( printf("cei: 3 still doing fine\n") );

	    DeleteImageRPort( rp );

	    D( printf("cei: 4 still doing fine\n") );
	}
	else 
	{
	    DeleteImage( im );
	    im = NULL;
	}
    }

    D( printf("CEI: returning: %lx\n", im ) );

    return ( im );
}
