/* dialt.c -- test for dial gadget routines	*/

/*
Copyright (c) 1989 Commodore-Amiga, Inc.

Executables based on this information may be used in software
for Commodore Amiga computers. All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#include "sysall.h"

struct  Window      *getNewWind();

struct  IntuitionBase   *IntuitionBase = NULL;
struct  GfxBase         *GfxBase = NULL;

ULONG   flg = WINDOWCLOSE | NOCAREREFRESH | WINDOWDRAG
    | WINDOWDEPTH | SIMPLE_REFRESH;

ULONG   iflg =	GADGETUP | GADGETDOWN |
		RAWKEY | MOUSEMOVE | MOUSEBUTTONS | CLOSEWINDOW;

#define DIALID	(99)	/* gadgetid for dial gadget	*/

main()
{
    struct  IntuiMessage	*msg;
    struct Window   	*window = NULL;
    WORD    		exitval = 0;
    struct Image	*CreateEllipseImage();
    struct Image	*ellipseimage = NULL;
    struct Gadget	*CreateDialGadget();
    struct Gadget	*dg;
    int			dialx, dialy;

    /* hold data from *msg  */
    ULONG   		class;
    USHORT  		code;
    APTR    		iaddr;
    UWORD		qualifier;
    struct HitPoint	mouse;

    if ((IntuitionBase = 
	(struct IntuitionBase *) OpenLibrary("intuition.library", 36L)
	) == NULL)
    {
	printf("NO INTUITION LIBRARY\n");
	exitval = 1;
	goto EXITING;
    }

    if ((GfxBase = 
	(struct GfxBase *) OpenLibrary("graphics.library", 36L)
	) == NULL)
    {
	printf("NO GRAPHICS LIBRARY\n");
	exitval = 2;
	goto EXITING;
    }

    /* init libraries and window    */
    window = getNewWind(121, 20, 500, 150, NULL, flg, iflg);
    if (window == NULL)
    {
	exitval = 1;
	goto EXITING;
    }

    if ( ! (ellipseimage =  CreateEllipseImage( 100, 50, 2, 2, 3, 2, 4 )))
    {
    	exitval = 1;
	goto EXITING;
    }

    if ( dg = CreateDialGadget( DIALID, ellipseimage ) )
    {
	/* finish the setup of the gadget	*/
	dg->LeftEdge = 30;
	dg->TopEdge = 20;
	dg->Activation |= GADGIMMEDIATE | RELVERIFY;

	AddGadget( window, dg, (long) ~0 );
	RefreshGList( dg, window, NULL, 1L );
    }
    else
    {
    	printf( "create dialg failed\n");
    }

    printf("test program ok\n");

    FOREVER
    {
	if ((msg = (struct IntuiMessage *)GetMsg(window->UserPort)) == NULL)
	{
	    Wait(1L<<window->UserPort->mp_SigBit);
	    continue;
	}

	/* Stash message contents and reply,
	 * important when message triggers some
	 * lengthy processing
	 */

	class   = msg->Class;
	code    = msg->Code;
	iaddr   = msg->IAddress;
	qualifier = msg->Qualifier;
	mouse = *( (struct HitPoint *) &msg->MouseX );

	ReplyMsg(msg);

	switch (class)
	{
	case GADGETUP:
	    printf(" gadgetup received\n");
	    if ( ((struct Gadget *) iaddr)->GadgetID == DIALID )
	    {
	    	printf(" dial gadget has been used.\n");
		GetDialCoords( iaddr, &dialx, &dialy );
		printf("coords are: %d/%d\n", dialx, dialy );
	    }
	    else printf( "unrecognized gadget message\n" );

	    break;

	case CLOSEWINDOW:
	    goto EXITING;
	}
    }

EXITING:
    if ( dg )
    {
	RemoveGadget( window, dg );
	DeleteDialGadget( dg );
    }
    DeleteImage( ellipseimage );

    if (window)
    {
    	CloseWindow(window);
    }

    if (GfxBase) CloseLibrary(GfxBase);
    if (IntuitionBase) CloseLibrary(IntuitionBase);

    exit (exitval);
}


struct  Window * getNewWind(left, top, width, height, screen, flg, iflg)
SHORT   left, top, width, height;
struct Screen	*screen;
ULONG   flg, iflg;
{
    struct  Window  *OpenWindow();
    struct  NewWindow   nw;

    nw.LeftEdge =   (SHORT) left;
    nw.TopEdge  =   (SHORT) top;
    nw.Width    =   (SHORT) width;
    nw.Height   =   (SHORT) height;
    nw.DetailPen    =   (UBYTE) -1;
    nw.BlockPen =   (UBYTE) -1;
    nw.IDCMPFlags   =   (ULONG) iflg;

    nw.Flags    =   (ULONG) flg;

    nw.FirstGadget  =   (struct Gadget *)   NULL;
    nw.CheckMark    =   (struct Image *)    NULL;
    nw.Title    =   (UBYTE *)   " Dial Test Window ";
    nw.Screen   =   screen;
    nw.BitMap   =   (struct BitMap *)   NULL;
    nw.MinWidth =   (SHORT) 50;
    nw.MinHeight=   (SHORT) 30;
    /* work around bug  */
    nw.MaxWidth =   (SHORT) nw.Width;
    nw.MaxHeight    =   (SHORT) nw.Height;
    nw.Type     =   (USHORT) (screen? CUSTOMSCREEN: WBENCHSCREEN);

    return ((struct Window *) OpenWindow(&nw));
}
