/* button.c -- labeled state buttons :ts=4	*/

/*
Copyright (c) 1989 Commodore-Amiga, Inc.

Executables based on this information may be used in software
for Commodore Amiga computers. All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#include <sysall.h>

#define D(x)	;

/* uses two images, On and Off	*/
static struct Image *bOffImage = NULL;		/* shared Image */
static struct Image *bOnImage = NULL;		/* shared Image */
/* text offset beyond box portion of image */
static int			bTextLeft;
static int			bTextTop;

struct Image	*CreateImage();
struct Image	*makeButtonImages();
struct Gadget	*CreateBoolGadget();
struct RastPort	*CreateImageRPort();

/*
 *	creates linked list of "button" state gadgets, with
 *	sequential GadgetID values.
 */
struct Gadget	*
buttonGadgets( rp, argv, numgad, id )
struct RastPort *rp;
char	**argv;
{
	int					num;
	char				**a;
	struct Rectangle	textent;
	struct Gadget		*glist = NULL;
	struct Gadget		*g;

	g = (struct Gadget *) &glist;

	textListExtent( rp, argv, numgad, &textent );

	if ( makeButtonImages( rp, &textent ) )
	{
		/* make gadget for each line of text */
		for ( a = argv, num = numgad; num; ++a, --num )
		{
			if (g->NextGadget=CreateBoolGadget(bOffImage,NULL,id++,*a))
			{
				g = g->NextGadget;
				D( printf("bG: gadget %lx\n", g ) );

				/* position gadget text */
				g->GadgetText->LeftEdge = bTextLeft;
				g->GadgetText->TopEdge = bTextTop;

				/* set gadget flags */
				g->Activation |= (GADGIMMEDIATE | TOGGLESELECT);
				g->Flags = (g->Flags & ~GADGHIGHBITS) | GADGHIMAGE;
				g->SelectRender = (APTR) bOnImage;
			}
			else
			{
				FreeGadgets( glist );
				glist = NULL;
				freeButtonImages();
				break;
			}
		}
	}
	D( printf("bG return: %lx\n", glist ) );
	return ( glist );
}

cleanupButtonGadgets()
{
	freeButtonImages();
}

/* feel free to localize these suckers	*/
UBYTE	*onoff[] = { (UBYTE *) "Off", (UBYTE *) "On" };

/*
 * creates two images, returns pointer to first, NULL if failure.
 */
struct Image	*
makeButtonImages( textrp, extent )
struct RastPort		*textrp;			/* for size of On/Off strings */
struct Rectangle	*extent;
{
	struct RastPort	*rp;
	struct RastPort	clonerp;

	int	width, height;
	int	oowidth, ooheight;
	struct Rectangle	ooextent;

	/* stuff for two passes at image creation	*/
	int		i;
	UBYTE	*imtext;
	struct Image	**doimage;
	UBYTE	fieldpen, textpen;


	/* get size of on/off box	*/
	textListExtent( textrp, onoff, 2, &ooextent );
	oowidth = ooextent.MaxX - ooextent.MinX + 1;
	ooheight = ooextent.MaxY - ooextent.MinY + 1;
	oowidth		+= 10;			/* scale by resolution soon	*/
	ooheight	+= 6;

	/* set up intuitext origins	*/
	bTextLeft	= oowidth + 16;
	bTextTop	= (ooheight - textrp->TxHeight)/2;

	/* set up IntuiText positions to the right of the on/off box	*/

	width = extent->MaxX - extent->MinX + 1 + bTextLeft;
	height = ooheight;					/* using same font/metric	*/
	width	+= 6;						/* scale by resolution soon	*/

	if ( !bOffImage )
	{
		for ( i = 0; i < 2; ++i )
		{
			imtext = onoff[ i ];
			if ( i )
			{
				doimage = &bOnImage;
				fieldpen = 2;
				textpen = 1;
			}
			else
			{
				fieldpen = 1;
				textpen = 2;
				doimage = &bOffImage;
			}

			if ( *doimage = CreateImage( width, height, 2 ) )
			{
				if ( rp = CreateImageRPort( *doimage ) )
				{
					drawBox( rp, oowidth, ooheight, fieldpen, 3, 2, 1 );

					/* clone font from textrp	*/
					clonerp = *textrp;
					clonerp.Layer = NULL;
					clonerp.BitMap = rp->BitMap;

					SetDrMd( &clonerp, (long) JAM1 );
					SetAPen( &clonerp, (long) textpen );

					Move( &clonerp,
					(long) (oowidth-textLength( &clonerp, imtext ))/2,
					(long) (ooheight - clonerp.TxHeight)/2 +
						clonerp.TxBaseline);

					Text( &clonerp, imtext, (long) strlen( imtext ) );

					DeleteImageRPort( rp );
				}
				else
				{
					freeButtonImages();		/* nulls out bOffImage */
					break;
				}
			}
		}
	}

	D( printf("mBI returning %lx\n", bOffImage ) );
	return ( bOffImage );
}

freeButtonImages()
{
	if ( bOffImage ) DeleteImage( bOffImage );
	bOffImage = NULL;

#if 0
	if ( bOnImage ) DeleteImage( bOnImage );
	bOnImage = NULL;
#endif
}



