
/******************************************************************************
*                                                                             *
*    genlock_example -- specifying the new V1.4 Genlock Modes to graphics.    *
*                                                                             *
*    Requires V1.4 KickStart and the new ECS chip set to display new modes.   *
*                                                                             *
******************************************************************************/

#include <exec/types.h>
#include <exec/memory.h>
#include <graphics/videocontrol.h>
#include <intuition/intuition.h>

#define V1_POINT_4 36

struct  GfxBase         *GfxBase = NULL;
struct  IntuitionBase   *IntuitionBase = NULL;

struct  Window      *new_window();

ULONG flg =  (WINDOWCLOSE|NOCAREREFRESH|WINDOWDRAG|WINDOWDEPTH|SIMPLE_REFRESH);
ULONG iflg = (CLOSEWINDOW) ;

error_message( error )
int error;
{
    switch( error )
    {
        case( -4 ): printf("error: can't open workbench window\n"); break;
        case( -3 ): printf("error: can't open workbench screen\n"); break;
        case( -2 ): printf("error: can't open 1.4 intuition.library\n"); break;
        case( -1 ): printf("error: can't open 1.4 graphics.library\n"); break;
    }
}

usage(progname)
char *progname;
{
  printf("%s ",progname);
  printf("[c\(\%%1c\)|C\(\%%1c\)] [p\(\%%1c\)|P\(\%%1c\)] [t|T] [b|B]  \n");
  printf("[c\(\%%1c\)|C\(\%%1c\)] ==   chroma key pen   n \(n == 0..9\)\n");
  printf("[p\(\%%1c\)|P\(\%%1c\)] == bitplane key plane n \(n == 0..9\)\n");
  printf("[t|T] == border not transparent\n");
  printf("[b|B] == border blanking\n");
}

struct TagItem vidcon[] =
{
    { VTAG_END_CM, NULL },
    { VTAG_END_CM, NULL },
    { VTAG_END_CM, NULL },
};

main(argc,argv)
int argc;
char *argv[];
{
    int      exitval = -1;
    struct   Screen *wbscreen = NULL;
    struct   Window *wbwindow = NULL;
    struct   IntuiMessage *msg = NULL;
    ULONG    class;
    ULONG    borderblank = 0;
    ULONG    borderntran = 0;
    ULONG    chromakey = 0;
    ULONG    penkey = 0;
    ULONG    bitplanekey = 0;
    ULONG    planekey = 0;

    char *title = " VideoControl Demo ";

    if(argc > 1)
    {
        int i;
        for(i=1; i<argc; i++)
        {
            switch((UBYTE)(*(*(argv+i))))
            {
                case 'b': borderblank = TRUE; break;
                case 'B': borderblank = TRUE; break;
                case 't': borderntran = TRUE; break;
                case 'T': borderntran = TRUE; break;
                case 'c': chromakey   = TRUE; penkey  =(*(argv[i]+1))-'0';break;
                case 'C': chromakey   = TRUE; penkey  =(*(argv[i]+1))-'0';break;
                case 'p': bitplanekey = TRUE; planekey=(*(argv[i]+1))-'0';break;
                case 'P': bitplanekey = TRUE; planekey=(*(argv[i]+1))-'0';break;
                case '?': usage(*argv); goto USAGE;
                default : usage(*argv); goto USAGE;
            }
        }
    }

    if (!(GfxBase = (struct GfxBase *)
        OpenLibrary("graphics.library", V1_POINT_4)))
    {
        exitval = ~(-1);
        goto EXITING;
    }

    if (!(IntuitionBase = (struct IntuitionBase *)
        OpenLibrary("intuition.library", V1_POINT_4)))
    {
        exitval = ~(-2);
        goto EXITING;
    }

    /* ------ Find the Workbench Screen ------------ */

    if((wbscreen = (struct Screen *)OpenWorkBench())==NULL)
    {
        exitval = ~(-3);
        goto USAGE;
    }

    /* ------ Set up the Genlock State ------------ */

    if((bitplanekey) || (chromakey) || (borderblank) || (borderntran))
    {
        if(borderblank) 
        {
            vidcon[0].ti_Tag  = VTAG_BORDERBLANK_SET;
            vidcon[0].ti_Data = NULL;
            vidcon[1].ti_Tag  = VTAG_END_CM;
            vidcon[1].ti_Data = NULL;
            VideoControl( wbscreen->ViewPort.ColorMap, vidcon );
        }
        if(borderntran) 
        {
            vidcon[0].ti_Tag  = VTAG_BORDERNOTRANS_SET;
            vidcon[0].ti_Data = NULL;
            vidcon[1].ti_Tag  = VTAG_END_CM;
            vidcon[1].ti_Data = NULL;
            VideoControl( wbscreen->ViewPort.ColorMap, vidcon );
        }
        if(chromakey) 
        {
            vidcon[0].ti_Tag  = VTAG_CHROMAKEY_SET;
            vidcon[0].ti_Data = NULL;
            vidcon[1].ti_Tag  = VTAG_CHROMA_PEN_SET;
            vidcon[1].ti_Data = penkey;
            vidcon[2].ti_Tag  = VTAG_END_CM;
            vidcon[2].ti_Data = NULL;
            VideoControl( wbscreen->ViewPort.ColorMap, vidcon );
        }
        if(bitplanekey)
        {
            vidcon[0].ti_Tag  = VTAG_BITPLANEKEY_SET;
            vidcon[0].ti_Data = NULL;
            vidcon[1].ti_Tag  = VTAG_CHROMA_PLANE_SET;
            vidcon[1].ti_Data = planekey;
            vidcon[2].ti_Tag  = VTAG_END_CM;
            vidcon[2].ti_Data = NULL;
            VideoControl( wbscreen->ViewPort.ColorMap, vidcon );
        }
    }

    /* ------ Display the Genlock State ------------ */

    MakeScreen( wbscreen );
    RethinkDisplay( );  /* activate the changes */

    wbwindow = new_window(320, 20, 300, 50, flg, iflg, title);

    if (wbwindow == NULL)
    {
        exitval = ~(-4);
        goto EXITING;
    }

    FOREVER
    {
        if ((msg = (struct IntuiMessage *)GetMsg(wbwindow->UserPort)) == NULL)
        {
            Wait((ULONG) 1<<wbwindow->UserPort->mp_SigBit);
            continue;
        }

        class = msg->Class; 
        ReplyMsg( msg );

        switch (class)
        {
            case CLOSEWINDOW: 
            {
                goto EXITING;
            }   
        }
    }

EXITING:

    /* ------ Cleanup the Genlock State ------------ */

    if( ( wbscreen  )
    &&  ((bitplanekey) || (chromakey) || (borderblank) || (borderntran)) )
    {
        if(borderblank) 
        {
            vidcon[0].ti_Tag  = VTAG_BORDERBLANK_CLR;
            vidcon[0].ti_Data = NULL;
            vidcon[1].ti_Tag  = VTAG_END_CM;
            vidcon[1].ti_Data = NULL;
            VideoControl( wbscreen->ViewPort.ColorMap, vidcon );
        }
        if(borderntran) 
        {
            vidcon[0].ti_Tag  = VTAG_BORDERNOTRANS_CLR;
            vidcon[0].ti_Data = NULL;
            vidcon[1].ti_Tag  = VTAG_END_CM;
            vidcon[1].ti_Data = NULL;
            VideoControl( wbscreen->ViewPort.ColorMap, vidcon );
        }
        if(chromakey) 
        {
            vidcon[0].ti_Tag  = VTAG_CHROMAKEY_CLR;
            vidcon[0].ti_Data = NULL;
            vidcon[1].ti_Tag  = VTAG_CHROMA_PEN_CLR;
            vidcon[1].ti_Data = penkey;
            vidcon[2].ti_Tag  = VTAG_END_CM;
            vidcon[2].ti_Data = NULL;
            VideoControl( wbscreen->ViewPort.ColorMap, vidcon );
        }
        if(bitplanekey)
        {
            vidcon[0].ti_Tag  = VTAG_BITPLANEKEY_CLR;
            vidcon[0].ti_Data = NULL;
            vidcon[1].ti_Tag  = VTAG_CHROMA_PLANE_SET;
            vidcon[1].ti_Data = planekey;
            vidcon[2].ti_Tag  = VTAG_END_CM;
            vidcon[2].ti_Data = NULL;
            VideoControl( wbscreen->ViewPort.ColorMap, vidcon );
        }
    }

    if (wbwindow)  CloseWindow(wbwindow);
    if (wbscreen)  MakeScreen( wbscreen );
    if (IntuitionBase)  RethinkDisplay( );  /* deactivate the changes */

USAGE:

    if (GfxBase)       CloseLibrary(GfxBase);
    if (IntuitionBase) CloseLibrary(IntuitionBase);
                       error_message( ~exitval );
    exit (~exitval);
}

struct  Window *new_window(left, top, width, height, flg, iflg, title)
WORD            left, top, width, height;
ULONG           flg, iflg;
char           *title;
{
    struct  Window  *OpenWindow();
    struct  NewWindow   nw;

    nw.LeftEdge         =   (WORD) left;
    nw.TopEdge          =   (WORD) top;
    nw.Width            =   (WORD) width;
    nw.Height           =   (WORD) height;
    nw.DetailPen        =   (UBYTE) -1;
    nw.BlockPen         =   (UBYTE) -1;
    nw.IDCMPFlags       =   (ULONG) iflg;
    nw.Flags            =   (ULONG) flg;
    nw.FirstGadget      =   (struct Gadget *)   NULL;
    nw.CheckMark        =   (struct Image *)    NULL;
    nw.Title            =   (UBYTE *)  title; 
    nw.Screen           =   (struct Screen *)   NULL;
    nw.BitMap           =   (struct BitMap *)   NULL;
    nw.MinWidth         =   (WORD) 50;
    nw.MinHeight        =   (WORD) 30;
    nw.MaxWidth         =   (WORD) nw.Width;
    nw.MaxHeight        =   (WORD) nw.Height;
    nw.Type             =   (UWORD) WBENCHSCREEN;

    return ((struct Window *) OpenWindow(&nw));
}


