/* apt2.c -- jude's autopoint, commoditized	*/

#include	"cx/cxusr.h"

#ifndef LIBNAME
#define LIBNAME "commodities.library"
#endif

#define D(x)	;

struct Library	*CxBase;

struct NewBroker mynb = {
	NB_VERSION,
	"autopoint2",
	"AutoPoint2",
	"SunWindows style window activation",	
								/* description				*/
	NBU_UNIQUE,
	0,							/* flags					*/
	0							/* default priority			*/
};


/* want to be signaled whenever the mouse moves with
 * neither button pressed.
 */
IX		myix = {
	IX_VERSION,				/* required									*/
	IECLASS_RAWMOUSE,

	0,						/* Code: won't care				*/
	0,						/* CodeMask: 0 means don't care */

							/* want no buttons down			*/
	0,
	(IEQUALIFIER_LEFTBUTTON |  IEQUALIFIER_RBUTTON),
	0						/* synonyms irrelevant			*/
};

main(argc, argv)
int		argc;
char	**argv;
{
	char			**tt;
	int				exitval = 0;
	long			sig; 		/* value as allocated (important to use LONG)*/
	CxObj			*broker = NULL;
	CxObj			*filter;

	sig = AllocSignal((LONG) -1);

	CxBase = OpenLibrary( LIBNAME, 2L);
	if (!CxBase) exit(1);

	tt = ArgArrayInit(argc, argv);
	mynb.nb_Pri = ArgInt(tt, "PRIORITY", 0);
	ArgArrayDone();

	if (!apt2_init()) goto ABORT;

	broker = CxBroker(&mynb, NULL);

	if (!broker)
	{
		exitval = 1;
		goto ABORT;
	}

	filter = CxFilter(NULL);
	if (!filter)
	{
		exitval = 1;
		goto ABORT;
	}

	SetFilterIX(filter, &myix);

	/** DEBUG **/
	D( AttachCxObj(filter, CxDebug( 0xDEADFACE)) );

	AttachCxObj(filter, CxSignal( FindTask(0L), sig));

	if (CxObjError(filter))
	{
		D( printf("nocapslock: filter error %lx\n", CxObjError(filter) ) );
		DeleteCxObjAll(filter);
		exitval = 2;
		goto ABORT;
	}

	AttachCxObj(broker, filter);

	/* all set, activate broker	*/
	ActivateCxObj(broker, 1L);

	/* responds to signals; there are no messages	*/
	while (1)
	{
		if( Wait((LONG) SIGBREAKF_CTRL_E | (1L << sig) ) & SIGBREAKF_CTRL_E )
		{
			D( printf("got break\n") );
			exitval = 1;
			goto GOT_BREAK;
		}
		autopoint2();
	}

GOT_BREAK:
ABORT:
	if (broker) DeleteCxObjAll(broker);
	CloseLibrary(CxBase);

	apt2_shutdown();
	FreeSignal(sig);

	exit (exitval);
}
