/* ix.h -- input expression definitions */

/*
Copyright (c) 1987, 1988, 1989 Jim Mackraz and I&I Computing.

Executables based on this information may be used in software
for Commodore Amiga computers.  All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#ifndef	IX_H
#define IX_H 1

#ifndef DEVICES_INPUTEVENT_H
#include <devices/inputevent.h>
#endif

#define IX_VERSION	2

struct InputXpression {
	UBYTE	ix_Version;		/* must be set to IX_VERSION	*/
	UBYTE	ix_Class;		/* class must match exactly		*/

	UWORD	ix_Code;
	UWORD	ix_CodeMask;	/* normally used for UPCODE		*/

	UWORD	ix_Qualifier;
	UWORD	ix_QualMask;
	UWORD	ix_QualSame;	/* synonyms in qualifier		*/
	};
typedef struct InputXpression IX;

/* QualSame identifiers	*/
#define	IXSYM_SHIFT	1		/* left- and right- shift are equivalent	*/
#define	IXSYM_CAPS	2		/* either shift or caps lock are equivalent	*/
#define	IXSYM_ALT	4		/* left- and right- alt are equivalent		*/

/* corresponding QualSame masks	*/
#define	IXSYM_SHIFTMASK	(IEQUALIFIER_LSHIFT	|  IEQUALIFIER_RSHIFT)
#define	IXSYM_CAPSMASK	(IXSYM_SHIFTMASK	| IEQUALIFIER_CAPSLOCK)
#define	IXSYM_ALTMASK	(IEQUALIFIER_LALT	|  IEQUALIFIER_RALT)

#define IX_NORMALQUALS	0x7FFF;  /* for QualMask field: avoid RELATIVEMOUSE */

/* matches nothing	*/
#define	NULL_IX(I)  ((I)->ix_Class == IECLASS_NULL)
 
#endif
