/* cxusr.h -- commodoties exchange application permissible include */

/*
Copyright (c) 1987, 1988, 1989 Jim Mackraz and I&I Computing.

Executables based on this information may be used in software
for Commodore Amiga computers.  All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#ifndef CXUSR_H
#define CXUSR_H 1

#ifndef SYSALL_H
#include "cx/sysall.h"
#endif

#ifndef IX_H
#include "cx/ix.h"
#endif

#ifndef BROKER_H
#include "cx/broker.h"
#endif

/** Fake data types for system private objects	*/
#ifndef CX_H
typedef	LONG	CxObj;
typedef	LONG	CxMsg;
#endif

/* Pointer to Function returning Long	*/
typedef LONG	(*PFL)();


/*********************************/
/**	Commodities Object Types	**/
/*********************************/
#define	CX_INVALID		0		/* not a valid object (probably null)	*/
#define	CX_FILTER		1		/* input event messages only	*/
#define	CX_TYPEFILTER	2		/* filter on message type		*/
#define	CX_SEND			3		/* sends a message				*/
#define	CX_SIGNAL		4		/* sends a signal				*/
#define	CX_TRANSLATE	5		/* translates IE into chain		*/
#define CX_BROKER		6		/* application representative	*/
#define	CX_DEBUG		7		/* dumps kprintf to serial port	*/
#define	CX_CUSTOM		8		/* application provids function	*/
#define CX_ZERO			9		/* system terminator node		*/

/*****************/
/**	CxMsg types	**/
/*****************/
#define CXM_UNIQUE	(1 << 4)	/* sent down broker by CxBroker()	*/
/* Obsolete: subsumed by CXM_COMMAND (below)	*/

/* Messages of this type rattle around the Commodities input network.
 * They will be sent to you by a Sender object, and passed to you
 * as a synchronous function call by a Custom object.
 *
 * The message port or function entry point is stored in the object,
 * and the ID field of the message will be set to what you arrange
 * issuing object.
 *
 * The Data field will point to the input event triggering the
 * message.
 */
#define CXM_IEVENT	(1 << 5)

/* These messages are sent to a port attached to your Broker.
 * They are sent to you when the controller program wants your
 * program to do something.  The ID field identifies the command.
 * 
 * The Data field will be used later.
 */
#define CXM_COMMAND	(1 << 6)

/* ID values	*/
#define CXCMD_DISABLE	(15)	/* please disable yourself	*/
#define CXCMD_ENABLE	(17)	/* please enable yourself	*/
#define CXCMD_APPEAR	(19)	/* open your window, if you can	*/
#define CXCMD_DISAPPEAR	(21)	/* go dormant				*/
#define CXCMD_KILL		(23)	/* go away for good			*/
#define CXCMD_UNIQUE	(25)	/* someone tried to create a broker
								 * with your name.  Suggest you Appear.
								 */

/* return values for BrokerCommand():	*/
#define CMDE_OK			(0)
#define CMDE_NOBROKER	(-1)
#define CMDE_NOPORT		(-2)
#define CMDE_NOMEM		(-3)

/* IMPORTANT NOTE: for V5:
 * Only CXM_IEVENT messages are passed through the input network.
 *
 * Other types of messages are sent to an optional port in your broker.
 *
 * This means that you must test the message type in your message handling,
 * if input messages and command messages come to the same port.
 *
 * Older programs have no broker port, so processing loops which
 * make assumptions about type won't encounter the new message types.
 *
 * The TypeFilter CxObject is hereby obsolete.
 *
 * It is less convenient for the application, but eliminates testing
 * for type of input messages.
 */

/**********************************************************/
/**	CxObj Error Flags (return values from CxObjError())	**/
/**********************************************************/
#define COERR_ISNULL		1	/* you called CxError(NULL)				*/
#define COERR_NULLATTACH	2	/* someone attached NULL to my list		*/
#define COERR_BADFILTER		4	/* a bad filter description was given	*/
#define COERR_BADTYPE		8	/* unmatched type-specific operation 	*/

#ifndef CXFUNCTIONS_H
#include "cx/cxfunctions.h"
#endif

#endif
