/* cxfunctions.h -- type declarations for Commodities Library functions  	*/
/* NOTICE TO LATTICE USERS: you would probably prefer to use cxlib.p	*/

/*
Copyright (c) 1987, 1988, 1989 Jim Mackraz and I&I Computing.

Executables based on this information may be used in software
for Commodore Amiga computers.  All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#ifndef	CXFUNCTIONS_H
#define  CXFUNCTIONS_H 1

#ifndef CXUSR_H
#include "cx/cxusr.h"
#endif

/* co.c			*/
CxObj	*CreateCxObj();
LONG	ActivateCxObj();
void	DeleteCxObj();
void	DeleteCxObjAll();
ULONG	CxObjType();
LONG	CxObjError();
void	ClearCxObjError();
void	SetCxObjPri();

/* colists.c	*/
void	AttachCxObj();
void	EnqueueCxObj();
void	InsertCxObj();
void	RemoveCxObj();

/* broker.h		*/
CxObj	*CxBroker();
CxObj	*FindBroker();

/* cxmethods.c	*/
void	SetTranslate();
void	SetFilter();
void	SetFilterIX();

/* pix.c		*/
LONG	ParseIX();

/* cxm.c		*/
ULONG	CxMsgType();
char	*CxMsgData();
LONG	CxMsgID();
void	DivertCxMsg();
void	RouteCxMsg();
void	DisposeCxMsg();

/* ikm.c */
ULONG	InvertKeyMap();

/* support (scanned) library function declarations	*/
CxObj	*HotKey();
char	**ArgArrayInit();
void	ArgArrayDone();
char	*ArgString();
int		ArgInt();
CxObj	*UserFilter();
struct InputEvent	*InvertString();

/* object creation macros	*/
#define CxFilter(d)			CreateCxObj((LONG) CX_FILTER, (LONG) d, 0)
#define CxTypeFilter(type)	CreateCxObj((LONG) CX_TYPEFILTER, (LONG) type, 0)
#define CxSender(port,id)	CreateCxObj((LONG) CX_SEND, (LONG) port, (LONG) id)
#define CxSignal(task,sig)	CreateCxObj((LONG) CX_SIGNAL,(LONG) task, (LONG) sig)
#define CxTranslate(ie)		CreateCxObj((LONG) CX_TRANSLATE, (LONG) ie, 0)
#define CxDebug(id)			CreateCxObj((LONG) CX_DEBUG, (LONG) id, 0)
#define CxCustom(action,id)	CreateCxObj((LONG) CX_CUSTOM,(LONG)action,(LONG)id)

#endif
