/* broker.h -- commodities broker related definitions	*/

/*
Copyright (c) 1987, 1988, 1989 Jim Mackraz and I&I Computing.

Executables based on this information may be used in software
for Commodore Amiga computers.  All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/


#ifndef BROKER_H
#define BROKER_H 1

/* buffer sizes	*/
#define	CBD_NAMELEN		24
#define	CBD_TITLELEN	40
#define	CBD_DESCRLEN	40

/* CxBroker errors	*/
#define	CBERR_OK		0
#define	CBERR_SYSERR	1
#define	CBERR_DUP		2			/* uniqueness violation			*/
#define	CBERR_VERSION	3			/* didn't understand nb_VERSION	*/

#define	NB_VERSION	5

struct NewBroker {
	BYTE			nb_Version;	/* set to NB_VERSION	*/
	BYTE			*nb_Name;
	BYTE			*nb_Title;
	BYTE			*nb_Descr;
	SHORT			nb_Unique;
	SHORT			nb_Flags;
	BYTE			nb_Pri;
	/* new in V5	*/
	struct MsgPort	*nb_Port;
	WORD			nb_ReservedChannel;		/* plans for later port sharing	*/
};

/* Flags for nb_Unique	*/
#define	NBU_DUPLICATE	0
#define	NBU_UNIQUE		1	/* will not allow duplicates			*/
#define	NBU_NOTIFY		2	/* sends CXM_UNIQUE to existing broker	*/

#endif
