/* demowindow.c -- Intuition Interface */

/*
Copyright (c) 1987, 1988, 1989 Jim Mackraz and I&I Computing.

Executables based on this information may be used in software
for Commodore Amiga computers.  All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#include "sysall.h"

#include <intuition/intuition.h>

#define D(x)	;
/* #define printf	kprintf */

extern struct MsgPort	*iport;
extern ULONG			isigflag;

struct Window	*window = NULL;

#define SLEEPGADGET	(25)
#define QUITGADGET  (26)

handleIMsg( msg )
struct IntuiMessage	*msg;
{
	ULONG	class;
	UWORD	code;
	struct Gadget	*gaddress;

	class = msg->Class;
	code = msg->Code;
	gaddress = (struct Gadget *) msg->IAddress;

	ReplyMsg( msg );

	switch ( class )
	{
	case CLOSEWINDOW:
		D( printf("close window (sleep)\n") );
		shutdownWindow();
		break;			/* not reached	*/

	case REFRESHWINDOW:
		D( printf("refresh window\n") );
		BeginRefresh( window );
		printMessage();
		EndRefresh( window, 1L );
		break;

	case GADGETUP:
		switch ( gaddress->GadgetID )
		{
		case SLEEPGADGET:
			shutdownWindow();
			break;

		case QUITGADGET:
			terminate();
		}
		break;
	}
}

/* save window positions and dims	*/
WORD	savewindow[ 4 ] =  { 134, 64, 362, 68 };

setupWindow()
{
	struct Window	*getNewWindow();

	if ( window )
	{	
		WindowToFront( window );
		return;		/* already setup, nothing to re-init	*/
	}

	/* open window	*/
	if ( ! ( window = getNewWindow() ) ) return;

	iport = window->UserPort;
	isigflag = 1L << iport->mp_SigBit;

	printMessage();
}

shutdownWindow()
{
	WORD	*wp;

	if ( ! window ) return;

	/* save window position	*/
	wp = savewindow;
	*wp++ = window->LeftEdge;
	*wp++ = window->TopEdge;
	*wp++ = window->Width;
	*wp = window->Height;

	CloseWindow( window );
	window = NULL;
	iport = NULL;
	isigflag = NULL;
}

#define IFLAGS (CLOSEWINDOW | GADGETUP | REFRESHWINDOW )

#define WFLAGS \
	(WINDOWCLOSE | WINDOWDRAG | WINDOWSIZING | WINDOWDEPTH | SIMPLE_REFRESH )

#define WTITLE	((UBYTE *) " Commodities Demo Pop-up Window ")

struct  Window *
getNewWindow()
{
    struct  Window  *OpenWindow();
    struct  NewWindow   nw;
	WORD	*wp = savewindow;

    nw.LeftEdge =   *wp++;
    nw.TopEdge  =   *wp++;
    nw.Width    =   *wp++;
    nw.Height   =   *wp++;
    nw.DetailPen    =   (UBYTE) -1;
    nw.BlockPen =   (UBYTE) -1;
    nw.IDCMPFlags   =  IFLAGS;

    nw.Flags    =   WFLAGS;

    nw.FirstGadget  =   NULL;
    nw.CheckMark    =   NULL;
    nw.Title    =   WTITLE;
    nw.Screen   =   NULL;
    nw.BitMap   =   NULL;
    nw.MinWidth =   50;
    nw.MinHeight=   30;
    /* work around bug  */
    nw.MaxWidth =   -1;
    nw.MaxHeight    =   -1;
    nw.Type     =   WBENCHSCREEN;

    return ((struct Window *) OpenWindow(&nw));
}

extern char	hotkeybuff[];

struct IntuiText	msgitext[2] = {
 { 1, 0, JAM1, 40, 30, NULL, (UBYTE *) "My Pop-Up Hotkey is:", &msgitext[1] },
 { 3, 0, JAM1, 60, 41, NULL, (UBYTE *) hotkeybuff, NULL },
};

printMessage()
{
	if ( window ) PrintIText( window->RPort, msgitext, 0L, 0L );
	return;
}
