/* democx.c -- Commodities interface */

/*
Copyright (c) 1987, 1988, 1989 Jim Mackraz and I&I Computing.

Executables based on this information may be used in software
for Commodore Amiga computers.  All other rights reserved.
This information is provided "as is"; no warranties are made.
All use is at your own risk, and no liability or responsibility
is assumed.
*/

#include "sysall.h"

#define D(x)	;
/* #define printf	kprintf */

#include <cx/cxusr.h>
#include <cx/broker.h>
#include <cx/cxfunctions.h>

extern struct MsgPort	*cxport;
extern ULONG			cxsigflag;

CxObj	*broker = NULL;

/* a little global for showing the user the hotkey	*/
char	hotkeybuff[ 257 ];

/* hotkey command definitions	*/
#define POPUP	(86L)		/* pop my window up if it isn't open	*/
#define DEFAULTPOP	("shift f1")

handleCxMsg( msg )
struct Message	*msg;
{
	ULONG	msgid;
	ULONG	msgtype;

	msgid = CxMsgID( msg );
	msgtype = CxMsgType( msg );

	D( printf( " handleCxMsg. type: %ld ID: %ld\n", msgtype, msgid ) );

	ReplyMsg( msg );

	D( printf( " handleCxMsg. type: %ld ID: %ld\n", msgtype, msgid ) );

	switch ( msgtype )
	{
	case CXM_IEVENT:
		if ( msgid == POPUP )  setupWindow();
		break;

	case CXM_COMMAND:
		switch ( msgid )
		{
		case CXCMD_DISABLE:
			ActivateCxObj( broker, 0L );
			break;
		case CXCMD_ENABLE:
			ActivateCxObj( broker, 1L );
			break;
		case CXCMD_APPEAR:
		case CXCMD_UNIQUE:
			setupWindow();
			break;
		case CXCMD_DISAPPEAR:
			shutdownWindow();
			break;
		case CXCMD_KILL:
			terminate();
			break;
		}
	}
}

struct NewBroker mynb = {
	NB_VERSION,
	"demoI&I",					/* broker internal name	*/
	"Popup Demo",				/* commodity title		*/
	"Commodities demonstration",/* description			*/
	NBU_NOTIFY | NBU_UNIQUE,	/* co-existence is low	*/
	0,							/* flags				*/
	0,							/* default priority		*/
	NULL,						/* port, will fill in	*/
	0							/* channel (reserved)	*/
};


/* may be called anytime to reinitialize commodities
 * elements for a new set of arguments
 */
setupCX( ttypes )
char	**ttypes;		/* "tooltypes" (null terminated) array	*/
{
	LONG	error;
	char	*str;

	shutdownCX();		/* remove what was	*/

	/* create everything from scratch	*/

	/* cx available to main program loop	*/
	cxport = CreatePort( mynb.nb_Name, 0L );
	if ( ! cxport ) return ( 0 );
	cxsigflag = 1L << cxport->mp_SigBit;

	/* set up some broker data from ttypes	*/
	mynb.nb_Pri = ArgInt( ttypes, "PRIORITY", 0 );
	mynb.nb_Port = cxport;

	/* init my commodities broker	*/
	if ( ! ( broker = CxBroker( &mynb, NULL ) ) )
	{
		D( printf("broker failed to create\n") );
		shutdownCX();
		return ( 0 );
	}

	/* install a hotkey for popping up window	*/
	AttachCxObj( broker,
		HotKey( str = ArgString( ttypes, "POPUP", DEFAULTPOP ),
			cxport, POPUP) );

	if ( error = CxObjError( broker ) )
	{
		D( printf( "accumulated broker error %ld\n", error ) );
		shutdownCX();
		return ( 0 );
	}

	strncpy( hotkeybuff, str, sizeof( hotkeybuff ) - 1 );

	ActivateCxObj( broker, 1L );

	return ( 1 );
}

shutdownCX()
{
	struct Message	*msg;

	D( printf( "shutdownCX.  broker now: %lx\n", broker ) );

	if ( cxport )
	{
		DeleteCxObjAll( broker );		/* safe, even if NULL	*/

		/* now that messages are shut off, clear port	*/
		while ( msg = GetMsg( cxport ) ) ReplyMsg( msg );
		DeletePort( cxport );

		cxport = NULL;
		cxsigflag = 0;
		broker = NULL;
	}
}

